/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.taglib.component;

import javax.faces.component.UIComponent;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.taglib.component.TobagoTagDeclaration;

public abstract class TobagoTag
extends UIComponentTag
implements TobagoTagDeclaration {
    private static final Log LOG = LogFactory.getLog(TobagoTag.class);
    private String label;
    private String title;
    private String width;
    private String height;
    private String hidden;
    private String readonly;
    private String disabled;
    private String inline;

    public int doStartTag() throws JspException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("doStartTag() rendererType  " + this.getRendererType()));
            LOG.debug((Object)("doStartTag() componentType " + this.getComponentType()));
        }
        return super.doStartTag();
    }

    public String getRendererType() {
        String name = this.getClass().getName();
        int beginIndex = name.lastIndexOf(46);
        beginIndex = beginIndex < 0 ? 0 : ++beginIndex;
        int endIndex = name.length() - 3;
        return name.substring(beginIndex, endIndex);
    }

    public void release() {
        super.release();
        this.hidden = null;
        this.readonly = null;
        this.disabled = null;
        this.inline = null;
        this.label = null;
        this.title = null;
        this.width = null;
        this.height = null;
    }

    protected void setProperties(UIComponent component) {
        super.setProperties(component);
        ComponentUtil.setStringProperty(component, "label", this.label);
        ComponentUtil.setStringProperty(component, "title", this.title);
        ComponentUtil.setBooleanProperty(component, "disabled", this.disabled);
        ComponentUtil.setBooleanProperty(component, "readonly", this.readonly);
        ComponentUtil.setBooleanProperty(component, "hidden", this.hidden);
        ComponentUtil.setBooleanProperty(component, "inline", this.inline);
        if (this.width != null) {
            LOG.warn((Object)("the with attribute is deprecated, please use a layout manager. (" + this.getClass().getSimpleName() + ")"));
        }
        ComponentUtil.setStringProperty(component, "width", this.width);
        if (this.height != null) {
            LOG.warn((Object)("the height attribute is deprecated, please use a layout manager. (" + this.getClass().getSimpleName() + ")"));
        }
        ComponentUtil.setStringProperty(component, "height", this.height);
    }

    public String getDisabled() {
        return this.disabled;
    }

    public void setDisabled(String disabled) {
        this.disabled = disabled;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getHidden() {
        return this.hidden;
    }

    public void setHidden(String hidden) {
        this.hidden = hidden;
    }

    public String getInline() {
        return this.inline;
    }

    public void setInline(String inline) {
        this.inline = inline;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getReadonly() {
        return this.readonly;
    }

    public void setReadonly(String readonly) {
        this.readonly = readonly;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }
}

