/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.util;

import java.util.Date;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DebugPhaseListener
implements PhaseListener {
    private static final Log LOG = LogFactory.getLog(DebugPhaseListener.class);
    private static final String KEY = DebugPhaseListener.class.getName() + "_ID_";

    public void afterPhase(PhaseEvent phaseEvent) {
        if (LOG.isInfoEnabled()) {
            Date start;
            Date end = new Date();
            Map map = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
            map.put(KEY + phaseEvent.getPhaseId().getOrdinal() + "E", end);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("After Phase :" + phaseEvent.getPhaseId() + " Time=" + end.getTime()));
            }
            if (LOG.isDebugEnabled()) {
                start = (Date)map.get(KEY + phaseEvent.getPhaseId().getOrdinal() + "S");
                LOG.debug((Object)("Phase " + phaseEvent.getPhaseId() + " needs " + (end.getTime() - start.getTime()) + " milliseconds"));
            }
            if (phaseEvent.getPhaseId().getOrdinal() == 6 && (start = (Date)map.get(KEY + "1S")) != null) {
                LOG.info((Object)("Total response time : " + (end.getTime() - start.getTime()) + " milliseconds"));
            }
        }
    }

    public void beforePhase(PhaseEvent phaseEvent) {
        if (LOG.isInfoEnabled()) {
            Date start = null;
            Map map = null;
            if (LOG.isDebugEnabled() || phaseEvent.getPhaseId().getOrdinal() == 1) {
                start = new Date();
                map = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
                map.put(KEY + phaseEvent.getPhaseId().getOrdinal() + "S", start);
            }
            if (LOG.isDebugEnabled()) {
                Date end = null;
                int ordinal = phaseEvent.getPhaseId().getOrdinal();
                while (end == null && ordinal > 0) {
                    end = (Date)map.get(KEY + --ordinal + "E");
                }
                if (end != null) {
                    LOG.debug((Object)("Time between phases " + ordinal + " and " + phaseEvent.getPhaseId().getOrdinal() + ": " + (start.getTime() - end.getTime()) + " milliseconds"));
                }
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Before Phase :" + phaseEvent.getPhaseId() + " Time=" + start.getTime()));
            }
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

