/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.util;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class HtmlWriterUtil {
    private static final Log LOG = LogFactory.getLog(HtmlWriterUtil.class);
    private static final int BUFFER_SIZE = 1028;
    private final Writer out;
    private final boolean utf8;
    private final char[][] charsToEscape;
    private final char[] buff;
    private int bufferIndex;
    private static final String[] ISO8859_1_ENTITIES = new String[]{"nbsp", "iexcl", "cent", "pound", "curren", "yen", "brvbar", "sect", "uml", "copy", "ordf", "laquo", "not", "shy", "reg", "macr", "deg", "plusmn", "sup2", "sup3", "acute", "micro", "para", "middot", "cedil", "sup1", "ordm", "raquo", "frac14", "frac12", "frac34", "iquest", "Agrave", "Aacute", "Acirc", "Atilde", "Auml", "Aring", "AElig", "Ccedil", "Egrave", "Eacute", "Ecirc", "Euml", "Igrave", "Iacute", "Icirc", "Iuml", "ETH", "Ntilde", "Ograve", "Oacute", "Ocirc", "Otilde", "Ouml", "times", "Oslash", "Ugrave", "Uacute", "Ucirc", "Uuml", "Yacute", "THORN", "szlig", "agrave", "aacute", "acirc", "atilde", "auml", "aring", "aelig", "ccedil", "egrave", "eacute", "ecirc", "euml", "igrave", "iacute", "icirc", "iuml", "eth", "ntilde", "ograve", "oacute", "ocirc", "otilde", "ouml", "divide", "oslash", "ugrave", "uacute", "ucirc", "uuml", "yacute", "thorn", "yuml"};
    private static final char[][] ATTRIBUTE_CHARS_TO_ESCAPE = new char[161][];
    private static final char[][] TEXT_CHARS_TO_ESCAPE;

    public HtmlWriterUtil(Writer out, String characterEncoding, boolean attribute) {
        this.out = out;
        this.utf8 = "utf-8".equalsIgnoreCase(characterEncoding);
        this.charsToEscape = attribute ? ATTRIBUTE_CHARS_TO_ESCAPE : TEXT_CHARS_TO_ESCAPE;
        this.buff = new char[1028];
    }

    public void writeAttributeValue(String text) throws IOException {
        this.writeAttributeValue(text.toCharArray(), 0, text.length());
    }

    public void writeAttributeValue(char[] text) throws IOException {
        this.writeEncodedValue(text, 0, text.length, true);
    }

    public void writeAttributeValue(char[] text, int start, int length) throws IOException {
        this.writeEncodedValue(text, start, length, true);
    }

    public void writeText(String text) throws IOException {
        this.writeText(text.toCharArray(), 0, text.length());
    }

    public void writeText(char[] text) throws IOException {
        this.writeEncodedValue(text, 0, text.length, false);
    }

    public void writeText(char[] text, int start, int length) throws IOException {
        this.writeEncodedValue(text, start, length, false);
    }

    private void writeEncodedValue(char[] text, int start, int length, boolean isAttribute) throws IOException {
        char ch;
        int i;
        int localIndex = -1;
        int end = start + length;
        for (i = start; i < end; ++i) {
            ch = text[i];
            if (ch < this.charsToEscape.length - 1 && this.charsToEscape[ch] == null) continue;
            localIndex = i;
            break;
        }
        if (localIndex == -1) {
            this.out.write(text, start, length);
        } else {
            this.out.write(text, start, localIndex);
            for (i = localIndex; i < end; ++i) {
                ch = text[i];
                if (ch < this.charsToEscape.length - 1) {
                    if (isAttribute && ch == '&' && i + 1 < end && text[i + 1] == '{') {
                        this.addToBuffer('&');
                        continue;
                    }
                    if (this.charsToEscape[ch] != null) {
                        for (char cha : this.charsToEscape[ch]) {
                            this.addToBuffer(cha);
                        }
                        continue;
                    }
                    this.addToBuffer(ch);
                    continue;
                }
                if (this.utf8) {
                    this.addToBuffer(ch);
                    continue;
                }
                if (ch <= '\u00ff') {
                    this.flushBuffer();
                    this.out.write(38);
                    for (char c : ISO8859_1_ENTITIES[ch - 160].toCharArray()) {
                        this.out.write(c);
                    }
                    this.out.write(59);
                    continue;
                }
                this.flushBuffer();
                this.writeDecRef(ch);
            }
            this.flushBuffer();
        }
    }

    private void writeDecRef(char ch) throws IOException {
        if (ch == 8364) {
            this.out.write("&euro;");
            return;
        }
        this.out.write("&#");
        int i = ch;
        if (i > 10000) {
            this.out.write(48 + i / 10000);
            this.out.write(48 + (i %= 10000) / 1000);
            this.out.write(48 + (i %= 1000) / 100);
            this.out.write(48 + (i %= 100) / 10);
            this.out.write(48 + (i %= 10));
        } else if (i > 1000) {
            this.out.write(48 + i / 1000);
            this.out.write(48 + (i %= 1000) / 100);
            this.out.write(48 + (i %= 100) / 10);
            this.out.write(48 + (i %= 10));
        } else {
            this.out.write(48 + i / 100);
            this.out.write(48 + (i %= 100) / 10);
            this.out.write(48 + (i %= 10));
        }
        this.out.write(59);
    }

    private void addToBuffer(char ch) throws IOException {
        if (this.bufferIndex >= 1028) {
            this.out.write(this.buff, 0, this.bufferIndex);
            this.bufferIndex = 0;
        }
        this.buff[this.bufferIndex] = ch;
        ++this.bufferIndex;
    }

    private void flushBuffer() throws IOException {
        if (this.bufferIndex > 0) {
            this.out.write(this.buff, 0, this.bufferIndex);
        }
        this.bufferIndex = 0;
    }

    public static boolean attributeValueMustEscaped(String name) {
        try {
            switch (name.charAt(0)) {
                case 'i': {
                    if (name.charAt(1) == 'd') {
                        return false;
                    }
                    break;
                }
                case 'n': {
                    if (name.charAt(1) == 'a' && name.charAt(2) == 'm' && name.charAt(3) == 'e') {
                        return false;
                    }
                    break;
                }
                case 'c': {
                    if (name.charAt(1) == 'l' && name.charAt(2) == 'a' && name.charAt(3) == 's' && name.charAt(4) == 's') {
                        return false;
                    }
                    break;
                }
                default: {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    static {
        HtmlWriterUtil.ATTRIBUTE_CHARS_TO_ESCAPE[34] = "&quot;".toCharArray();
        HtmlWriterUtil.ATTRIBUTE_CHARS_TO_ESCAPE[38] = "&amp;".toCharArray();
        HtmlWriterUtil.ATTRIBUTE_CHARS_TO_ESCAPE[62] = "&gt;".toCharArray();
        TEXT_CHARS_TO_ESCAPE = new char[ATTRIBUTE_CHARS_TO_ESCAPE.length][];
        System.arraycopy(ATTRIBUTE_CHARS_TO_ESCAPE, 0, TEXT_CHARS_TO_ESCAPE, 0, ATTRIBUTE_CHARS_TO_ESCAPE.length);
        HtmlWriterUtil.TEXT_CHARS_TO_ESCAPE[60] = "&lt;".toCharArray();
    }
}

