/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutInfo {
    private static final int FREE = -1;
    private static final Log LOG = LogFactory.getLog(LayoutInfo.class);
    public static final int HIDE = -2;
    public static final String HIDE_CELL = "hide";
    private int cellsLeft;
    private int spaceLeft;
    private int[] spaces;
    private String[] layoutTokens;

    public LayoutInfo(int cellCount, int space, String layout) {
        this(cellCount, space, LayoutInfo.createLayoutTokens(layout, cellCount), false);
    }

    public LayoutInfo(int cellCount, int space, String[] layoutTokens, boolean ignoreMismatch) {
        this.cellsLeft = cellCount;
        this.spaceLeft = space;
        if (layoutTokens.length == cellCount) {
            this.layoutTokens = layoutTokens;
        } else if (layoutTokens.length > cellCount) {
            if (!ignoreMismatch && LOG.isWarnEnabled()) {
                LOG.warn((Object)("More tokens (" + layoutTokens.length + ") for layout than cells (" + cellCount + ") found! Ignoring" + " redundant tokens. Token string was: " + LayoutInfo.tokensToString(layoutTokens)));
            }
            this.layoutTokens = new String[cellCount];
            System.arraycopy(layoutTokens, 0, this.layoutTokens, 0, cellCount);
        } else {
            if (!ignoreMismatch && LOG.isWarnEnabled()) {
                LOG.warn((Object)(Integer.toString(cellCount - layoutTokens.length) + "More cells (" + cellCount + ") than tokens (" + layoutTokens.length + ") for layout found! Setting missing tokens to '1*'." + " Token string was: " + LayoutInfo.tokensToString(layoutTokens)));
            }
            this.layoutTokens = new String[cellCount];
            for (int i = 0; i < cellCount; ++i) {
                this.layoutTokens[i] = i < layoutTokens.length ? layoutTokens[i] : "1*";
            }
        }
        this.createAndInitSpaces(cellCount, -1);
    }

    private void createAndInitSpaces(int columns, int initValue) {
        this.spaces = new int[columns];
        for (int j = 0; j < this.spaces.length; ++j) {
            this.spaces[j] = initValue;
        }
    }

    public void update(int space, int index) {
        if (space > this.spaceLeft) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("More space (" + space + ") needed than available (" + this.spaceLeft + ")! Cutting to fit."));
            }
            space = this.spaceLeft;
        }
        this.spaceLeft -= space;
        --this.cellsLeft;
        if (index < this.spaces.length) {
            this.spaces[index] = space;
            if (this.spaceLeft < 1 && this.columnsLeft() && LOG.isWarnEnabled()) {
                LOG.warn((Object)("There are columns left but no more space! cellsLeft=" + this.cellsLeft + ", tokens=" + LayoutInfo.tokensToString(this.layoutTokens)));
                LOG.warn((Object)("calculated spaces = " + LayoutInfo.tokensToString(this.spaces)));
            }
        } else {
            LOG.warn((Object)("More space to assign (" + space + "px) but no more columns!" + " More layout tokens than column tags?"));
        }
    }

    public boolean columnsLeft() {
        return this.cellsLeft > 0;
    }

    public void handleIllegalTokens() {
        for (int i = 0; i < this.spaces.length; ++i) {
            if (!this.isFree(i)) continue;
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Illegal layout token pattern \"" + this.layoutTokens[i] + "\" ignored, set to 0px !"));
            }
            this.spaces[i] = 0;
        }
    }

    public static String[] createLayoutTokens(String columnLayout, int count) {
        return LayoutInfo.createLayoutTokens(columnLayout, count, "1*");
    }

    public static String[] createLayoutTokens(String columnLayout, int count, String defaultToken) {
        String[] tokens;
        if (columnLayout != null) {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(columnLayout, ";");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                if ("*".equals(token)) {
                    token = "1*";
                }
                list.add(token);
            }
            tokens = list.toArray(new String[list.size()]);
        } else {
            defaultToken = "*".equals(defaultToken) ? "1*" : defaultToken;
            tokens = new String[count];
            for (int i = 0; i < tokens.length; ++i) {
                tokens[i] = defaultToken;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("created Tokens : " + LayoutInfo.tokensToString(tokens)));
        }
        return tokens;
    }

    public static String listToTokenString(List list) {
        String[] tokens = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            tokens[i] = list.get(i).toString();
        }
        return LayoutInfo.tokensToString(tokens);
    }

    public static String tokensToString(int[] tokens) {
        String[] strings = new String[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            strings[i] = Integer.toString(tokens[i]);
        }
        return LayoutInfo.tokensToString(strings);
    }

    public static String tokensToString(String[] tokens) {
        StringBuffer sb = new StringBuffer();
        for (String token : tokens) {
            if (sb.length() != 0) {
                sb.append(";");
            }
            sb.append(token);
        }
        sb.insert(0, "\"");
        sb.append("\"");
        return sb.toString();
    }

    public boolean isFree(int column) {
        return this.spaces[column] == -1;
    }

    public int getSpaceForColumn(int column) {
        return this.spaces[column];
    }

    public int getSpaceLeft() {
        return this.spaceLeft;
    }

    public String[] getLayoutTokens() {
        return this.layoutTokens;
    }

    public boolean hasLayoutTokens() {
        return this.layoutTokens.length > 0;
    }

    public List<Integer> getSpaceList() {
        ArrayList<Integer> list = new ArrayList<Integer>(this.spaces.length);
        for (int space : this.spaces) {
            list.add(space);
        }
        return list;
    }

    public void handleSpaceLeft() {
        if (this.spaceLeft > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("spread spaceLeft (" + this.spaceLeft + "px) to columns"));
                LOG.debug((Object)("spaces before spread :" + this.arrayAsString(this.spaces)));
            }
            for (int i = 0; i < this.layoutTokens.length; ++i) {
                if (!"*".equals(this.layoutTokens[i])) continue;
                this.addSpace(this.spaceLeft, i);
                break;
            }
            boolean found = false;
            while (this.spaceLeft > 0) {
                for (int i = this.layoutTokens.length - 1; i > -1; --i) {
                    String layoutToken = this.layoutTokens[i];
                    if (this.spaceLeft <= 0 || !layoutToken.matches("^\\d+\\*")) continue;
                    found = true;
                    this.addSpace(1, i);
                }
                if (found) continue;
            }
        }
        if (this.spaceLeft > 0 && LOG.isWarnEnabled()) {
            LOG.warn((Object)("Space left after spreading : " + this.spaceLeft + "px!"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("spaces after spread  :" + this.arrayAsString(this.spaces)));
        }
    }

    private String arrayAsString(int[] currentSpaces) {
        StringBuffer sb = new StringBuffer("[");
        for (int currentSpace : currentSpaces) {
            sb.append(currentSpace);
            sb.append(", ");
        }
        sb.replace(sb.lastIndexOf(", "), sb.length(), "]");
        return sb.toString();
    }

    private void addSpace(int space, int i) {
        if (this.spaces[i] > -2) {
            if (this.spaces[i] == -1) {
                this.spaces[i] = space;
            } else {
                int n = i;
                this.spaces[n] = this.spaces[n] + space;
            }
            this.spaceLeft -= space;
        }
    }

    public void parseHides(int padding) {
        String[] tokens = this.getLayoutTokens();
        for (int i = 0; i < tokens.length; ++i) {
            if (!tokens[i].equals(HIDE_CELL)) continue;
            this.update(0, i);
            this.spaces[i] = -2;
            if (i != 0) {
                this.spaceLeft += padding;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("set column " + i + " from " + tokens[i] + " to hide "));
        }
    }

    public void parsePixels() {
        String[] tokens = this.getLayoutTokens();
        for (int i = 0; i < tokens.length; ++i) {
            if (!tokens[i].endsWith("px")) continue;
            String token = tokens[i].substring(0, tokens[i].length() - 2);
            try {
                int w = Integer.parseInt(token);
                this.update(w, i);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("set column " + i + " from " + tokens[i] + " to with " + w));
                continue;
            }
            catch (NumberFormatException e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)("NumberFormatException parsing " + tokens[i]));
            }
        }
    }

    public void parsePercent(double innerWidth) {
        String[] tokens = this.getLayoutTokens();
        if (this.columnsLeft()) {
            for (int i = 0; i < tokens.length; ++i) {
                if (!this.isFree(i) || !tokens[i].endsWith("%")) continue;
                String token = tokens[i].substring(0, tokens[i].length() - 1);
                try {
                    int percent = Integer.parseInt(token);
                    int w = (int)(innerWidth / 100.0 * (double)percent);
                    this.update(w, i);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("set column " + i + " from " + tokens[i] + " to with " + w));
                    continue;
                }
                catch (NumberFormatException e) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn((Object)("NumberFormatException parsing " + tokens[i]));
                }
            }
        }
    }

    public void parsePortions() {
        String[] tokens = this.getLayoutTokens();
        if (this.columnsLeft()) {
            int portions = 0;
            for (int i = 0; i < tokens.length; ++i) {
                if (!this.isFree(i) || !tokens[i].matches("^\\d+\\*")) continue;
                String token = tokens[i].substring(0, tokens[i].length() - 1);
                try {
                    portions += Integer.parseInt(token);
                    continue;
                }
                catch (NumberFormatException e) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn((Object)("NumberFormatException parsing " + tokens[i]));
                }
            }
            if (portions > 0) {
                int widthForPortions = this.getSpaceLeft();
                for (int i = 0; i < tokens.length; ++i) {
                    if (!this.isFree(i) || !tokens[i].matches("^\\d+\\*")) continue;
                    String token = tokens[i].substring(0, tokens[i].length() - 1);
                    try {
                        int portion = Integer.parseInt(token);
                        float w = (float)widthForPortions / (float)portions * (float)portion;
                        this.update(Math.round(w), i);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("set column " + i + " from " + tokens[i] + " to with " + w + " == " + Math.round(w) + "px"));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        if (!LOG.isWarnEnabled()) continue;
                        LOG.warn((Object)("NumberFormatException parsing " + tokens[i]));
                    }
                }
            }
        }
    }

    public void parseColumnLayout(double space) {
        this.parseColumnLayout(space, 0);
    }

    public void parseColumnLayout(double space, int padding) {
        if (this.hasLayoutTokens()) {
            this.parseHides(padding);
            this.parsePixels();
            this.parsePercent(space);
            this.parsePortions();
            this.handleSpaceLeft();
        }
        if (this.columnsLeft() && LOG.isWarnEnabled()) {
            this.handleIllegalTokens();
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("cellLeft", this.cellsLeft).append("spaceLeft", this.spaceLeft).append("spaces", this.spaces).append("layoutTokens", (Object[])this.layoutTokens).toString();
    }
}

