/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;

public class MessageFactory {
    private static final Log LOG = LogFactory.getLog(MessageFactory.class);
    private static Map<Locale, ResourceBundle> facesMessagesMap = new HashMap<Locale, ResourceBundle>();

    public static FacesMessage createFacesMessage(FacesContext facesContext, String key, FacesMessage.Severity severity) {
        return MessageFactory.createFacesMessage(facesContext, "tobago", key, severity);
    }

    public static FacesMessage createFacesMessage(FacesContext facesContext, String bundle, String key, FacesMessage.Severity severity) {
        String summary = MessageFactory.getMessageText(facesContext, bundle, key);
        String detail = MessageFactory.getMessageText(facesContext, bundle, key + "_detail");
        return new FacesMessage(severity, summary != null ? summary : key, detail);
    }

    private static String getMessageText(FacesContext facesContext, String bundle, String key) {
        String message = ResourceManagerUtil.getProperty(facesContext, bundle, key);
        if (message == null || message.length() < 1) {
            try {
                Locale locale = facesContext.getViewRoot().getLocale();
                message = MessageFactory.getFacesMessages(locale).getString(key);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return message;
    }

    private static ResourceBundle getFacesMessages(Locale locale) {
        ResourceBundle facesMessages = facesMessagesMap.get(locale);
        if (facesMessages == null) {
            facesMessages = ResourceBundle.getBundle("javax.faces.Messages", locale);
            facesMessagesMap.put(locale, facesMessages);
        }
        return facesMessages;
    }
}

