/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtils {
    public static String escape(String s) {
        return XmlUtils.escape(s, true);
    }

    public static String escape(String s, boolean isAttributeValue) {
        if (null == s) {
            return "";
        }
        int len = s.length();
        StringBuffer buffer = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            XmlUtils.appendEntityRef(buffer, s.charAt(i), isAttributeValue);
        }
        return buffer.toString();
    }

    private static void appendEntityRef(StringBuffer buffer, char ch, boolean isAttributeValue) {
        switch (ch) {
            case '<': {
                buffer.append("&lt;");
                break;
            }
            case '&': {
                buffer.append("&amp;");
                break;
            }
            case '\"': {
                if (isAttributeValue) {
                    buffer.append("&quot;");
                    break;
                }
                buffer.append(ch);
                break;
            }
            case '\'': {
                if (isAttributeValue) {
                    buffer.append("&apos;");
                    break;
                }
                buffer.append(ch);
                break;
            }
            case '>': {
                buffer.append("&gt;");
                break;
            }
            default: {
                buffer.append(ch);
            }
        }
    }

    public static void load(Properties properties, InputStream stream) throws IOException {
        Document document;
        try {
            document = XmlUtils.createDocument(stream);
        }
        catch (SAXException e) {
            throw new RuntimeException("Invalid properties format", e);
        }
        Element propertiesElement = (Element)document.getChildNodes().item(document.getChildNodes().getLength() - 1);
        XmlUtils.importProperties(properties, propertiesElement);
    }

    private static Document createDocument(InputStream stream) throws SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setValidating(false);
        factory.setCoalescing(true);
        factory.setIgnoringComments(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new Resolver());
            InputSource source = new InputSource(stream);
            return builder.parse(source);
        }
        catch (ParserConfigurationException e) {
            throw new Error(e);
        }
    }

    static void importProperties(Properties properties, Element propertiesElement) {
        int start;
        int numEntries;
        for (int i = start = (numEntries = (entries = propertiesElement.getChildNodes()).getLength()) > 0 && entries.item(0).getNodeName().equals("comment") ? 1 : 0; i < numEntries; ++i) {
            Element entry;
            NodeList entries;
            Node child = entries.item(i);
            if (!(child instanceof Element) || !(entry = (Element)child).hasAttribute("key")) continue;
            Node node = entry.getFirstChild();
            String value = node == null ? "" : node.getNodeValue();
            properties.setProperty(entry.getAttribute("key"), value);
        }
    }

    private static class Resolver
    implements EntityResolver {
        private Resolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            String dtd = "<!ELEMENT properties (comment?, entry*)><!ATTLIST properties version CDATA #FIXED '1.0'><!ELEMENT comment (#PCDATA)><!ELEMENT entry (#PCDATA)><!ATTLIST entry key CDATA #REQUIRED>";
            InputSource inputSource = new InputSource(new StringReader(dtd));
            inputSource.setSystemId("http://java.sun.com/dtd/properties.dtd");
            return inputSource;
        }
    }
}

