/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.webapp;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.webapp.TobagoMultipartFormdataRequest;
import org.apache.myfaces.tobago.webapp.TobagoResponse;

public class TobagoMultipartFormdataFilter
implements Filter {
    private static final Log LOG = LogFactory.getLog(TobagoMultipartFormdataFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object wrapper;
        if (request instanceof HttpServletRequest) {
            if (request instanceof TobagoMultipartFormdataRequest) {
                wrapper = request;
            } else {
                String contentType = request.getContentType();
                if (contentType != null && contentType.toLowerCase().startsWith("multipart/form-data")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Wrapping " + request.getClass().getName() + " with ContentType=\"" + contentType + "\" " + "into TobagoMultipartFormdataRequest"));
                    }
                    wrapper = new TobagoMultipartFormdataRequest((HttpServletRequest)request);
                } else {
                    wrapper = request;
                }
            }
        } else {
            LOG.error((Object)"Not implemented for non HttpServletRequest");
            wrapper = request;
        }
        TobagoResponse wrappedResponse = new TobagoResponse((HttpServletResponse)response);
        chain.doFilter(wrapper, (ServletResponse)wrappedResponse);
    }

    public void destroy() {
    }
}

