/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.webapp;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TobagoMultipartFormdataRequest
extends HttpServletRequestWrapper {
    private static final Log LOG = LogFactory.getLog(TobagoMultipartFormdataRequest.class);
    private Map parameters;
    private Map fileItems;

    TobagoMultipartFormdataRequest(HttpServletRequest request) {
        super(request);
        List itemList;
        String contentType = request.getContentType();
        if (contentType == null || !contentType.toLowerCase().startsWith("multipart/form-data")) {
            String errorText = "contentType is not multipart/form-data but '" + contentType + "'";
            LOG.error((Object)errorText);
            throw new FacesException(errorText);
        }
        this.parameters = new HashMap();
        this.fileItems = new HashMap();
        DiskFileUpload fileUpload = new DiskFileUpload();
        fileUpload.setSizeMax(0x100000L);
        fileUpload.setRepositoryPath(System.getProperty("java.io.tmpdir"));
        try {
            itemList = fileUpload.parseRequest(request);
        }
        catch (FileUploadException e) {
            LOG.error((Object)e);
            throw new FacesException((Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("parametercount = " + itemList.size()));
        }
        for (FileItem item : itemList) {
            String key = item.getFieldName();
            if (LOG.isDebugEnabled()) {
                String value = item.getString();
                if (value.length() > 100) {
                    value = value.substring(0, 100) + " [...]";
                }
                LOG.debug((Object)("Parameter : '" + key + "'='" + value + "' isFormField=" + item.isFormField() + " contentType='" + item.getContentType() + "'"));
            }
            if (item.isFormField()) {
                Object inStock = this.parameters.get(key);
                if (inStock == null) {
                    String[] values;
                    try {
                        values = new String[]{item.getString("utf-8")};
                    }
                    catch (UnsupportedEncodingException e) {
                        LOG.error((Object)("Catched: " + e.getMessage()), (Throwable)e);
                        values = new String[]{item.getString()};
                    }
                    this.parameters.put(key, values);
                    continue;
                }
                if (inStock instanceof String[]) {
                    String[] oldValues = (String[])inStock;
                    String[] values = new String[oldValues.length + 1];
                    for (int i = 0; i < oldValues.length; ++i) {
                        values[i] = oldValues[i];
                    }
                    try {
                        values[i] = item.getString("utf-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        LOG.error((Object)("Catched: " + e.getMessage()), (Throwable)e);
                        values[i] = item.getString();
                    }
                    this.parameters.put(key, values);
                    continue;
                }
                LOG.error((Object)("Program error. Unsupported class: " + inStock.getClass().getName()));
                continue;
            }
            this.fileItems.put(key, item);
        }
    }

    public FileItem getFileItem(String key) {
        if (this.fileItems != null) {
            return (FileItem)this.fileItems.get(key);
        }
        return null;
    }

    public String getParameter(String key) {
        String parameter = null;
        String[] values = (String[])this.parameters.get(key);
        if (values != null) {
            parameter = values[0];
        }
        return parameter;
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String key) {
        return (String[])this.parameters.get(key);
    }

    public Map getParameterMap() {
        return this.parameters;
    }
}

