/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.webapp;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.util.HtmlWriterUtil;
import org.apache.myfaces.tobago.util.XmlUtils;

public class TobagoResponseWriter
extends ResponseWriter {
    private static final Log LOG = LogFactory.getLog(TobagoResponseWriter.class);
    private static final Set<String> EMPTY_TAG = new HashSet<String>(Arrays.asList("br", "area", "link", "img", "param", "hr", "input", "col", "base", "meta"));
    private Writer writer;
    private UIComponent component;
    private boolean startStillOpen;
    private String contentType;
    private String characterEncoding;
    private Stack<String> stack;
    private boolean xml;
    private boolean insideScriptOrStyle = false;
    private HtmlWriterUtil attributeWriter;
    private HtmlWriterUtil textWriter;

    public TobagoResponseWriter(Writer writer, String contentType, String characterEncoding) {
        this.writer = writer;
        this.stack = new Stack();
        this.contentType = contentType;
        this.characterEncoding = characterEncoding;
        if ("application/xhtml".equals(contentType) || "application/xml".equals(contentType) || "text/xml".equals(contentType)) {
            this.xml = true;
        }
        this.attributeWriter = new HtmlWriterUtil((Writer)((Object)this), characterEncoding, true);
        this.textWriter = new HtmlWriterUtil((Writer)((Object)this), characterEncoding, false);
    }

    private String findValue(Object value, String property) {
        if (value != null) {
            return value instanceof String ? (String)value : value.toString();
        }
        if (property != null) {
            if (this.component != null) {
                Object object = this.component.getAttributes().get(property);
                if (object != null) {
                    return object instanceof String ? (String)object : object.toString();
                }
                return null;
            }
            String trace = this.getCallingClassStackTraceElementString();
            LOG.error((Object)("Don't know what to do! Property defined, but no component to get a value. " + trace.substring(trace.indexOf(40))));
            LOG.error((Object)("value = '" + value + "'"));
            LOG.error((Object)("property = '" + property + "'"));
            return null;
        }
        String trace = this.getCallingClassStackTraceElementString();
        LOG.error((Object)("Don't know what to do! No value and no property defined. " + trace.substring(trace.indexOf(40))));
        LOG.error((Object)("value = '" + value + "'"));
        LOG.error((Object)("property = '" + property + "'"));
        return null;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    public void write(String str) throws IOException {
        if (this.startStillOpen) {
            this.writer.write("\n>");
            this.startStillOpen = false;
        }
        super.write(str);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void writeText(Object text, String property) throws IOException {
        if (this.startStillOpen) {
            this.writer.write("\n>");
            this.startStillOpen = false;
        }
        String value = this.findValue(text, property);
        if (this.insideScriptOrStyle) {
            this.write(value);
        } else if (this.xml) {
            this.write(XmlUtils.escape(value));
        } else {
            this.textWriter.writeText(value);
        }
    }

    public void writeText(char[] text, int offset, int length) throws IOException {
        if (this.startStillOpen) {
            this.writer.write("\n>");
            this.startStillOpen = false;
        }
        if (this.insideScriptOrStyle) {
            this.writer.write(text, offset, length);
        } else if (this.xml) {
            this.writer.write(XmlUtils.escape(text.toString()).toCharArray(), offset, length);
        } else {
            this.textWriter.writeText(text, offset, length);
        }
    }

    public void startDocument() throws IOException {
    }

    public void endDocument() throws IOException {
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void startElement(String name) throws IOException {
        this.startElement(name, null);
    }

    public void startElement(String name, UIComponent currentComponent) throws IOException {
        this.component = currentComponent;
        this.stack.push(name);
        this.insideScriptOrStyle = TobagoResponseWriter.isScriptOrStyle(name);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("start Element: " + name));
        }
        if (this.startStillOpen) {
            this.writer.write("\n>");
        }
        this.writer.write("<");
        this.writer.write(name);
        this.startStillOpen = true;
    }

    private static boolean isScriptOrStyle(String name) {
        block11: {
            try {
                switch (name.charAt(0)) {
                    case 's': {
                        switch (name.charAt(1)) {
                            case 'c': {
                                if (name.charAt(2) == 'r' && name.charAt(3) == 'i' && name.charAt(4) == 'p' && name.charAt(5) == 't') {
                                    return true;
                                }
                                break block11;
                            }
                            case 't': {
                                if (name.charAt(2) == 'y' && name.charAt(3) == 'l' && name.charAt(4) == 'e') {
                                    return true;
                                }
                                break block11;
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                    default: {
                        return false;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void endElement(String name) throws IOException {
        String top;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("end Element: " + name));
        }
        if (!(top = this.stack.pop()).equals(name)) {
            String trace = this.getCallingClassStackTraceElementString();
            LOG.error((Object)("Element end with name='" + name + "' doesn't " + "match with top element on the stack='" + top + "' " + trace.substring(trace.indexOf(40))));
        }
        this.insideScriptOrStyle = false;
        if (EMPTY_TAG.contains(name)) {
            if (this.xml) {
                this.writer.write("\n/>");
            } else {
                this.writer.write("\n>");
            }
        } else {
            if (this.startStillOpen) {
                this.writer.write("\n>");
            }
            this.writer.write("</");
            this.writer.write(name);
            this.writer.write(">");
        }
        this.startStillOpen = false;
    }

    public void writeComment(Object obj) throws IOException {
        if (this.startStillOpen) {
            this.writer.write("\n>");
            this.startStillOpen = false;
        }
        String comment = obj.toString();
        this.write("<!--");
        if (comment.indexOf("--") < 0) {
            this.write(comment);
        } else {
            String trace = this.getCallingClassStackTraceElementString();
            LOG.warn((Object)("Comment must not contain the sequence '--', comment = '" + comment + "' " + trace.substring(trace.indexOf(40))));
            this.write(StringUtils.replace((String)comment, (String)"--", (String)"++"));
        }
        this.write("-->");
    }

    public ResponseWriter cloneWithWriter(Writer originalWriter) {
        return new TobagoResponseWriter(originalWriter, this.getContentType(), this.getCharacterEncoding());
    }

    public void writeAttribute(String name, boolean on) throws IOException {
        if (on) {
            this.writeAttribute(name, name, false);
        }
    }

    public void writeComponentAttribute(String name, String property) throws IOException {
        this.writeAttribute(name, null, property, true);
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        this.writeAttribute(name, value, property, true);
    }

    public void writeAttribute(String name, Object value, boolean escape) throws IOException {
        this.writeAttribute(name, value.toString(), escape);
    }

    public void writeAttribute(String name, String value, boolean escape) throws IOException {
        if (!this.startStillOpen) {
            String trace = this.getCallingClassStackTraceElementString();
            String error = "Cannot write attribute when start-tag not open. name = '" + name + "' " + "value = '" + value + "' " + trace.substring(trace.indexOf(40));
            LOG.error((Object)error);
            throw new IllegalStateException(error);
        }
        if (value != null) {
            this.writer.write(32);
            this.writer.write(name);
            this.writer.write("=\"");
            if (this.xml) {
                this.writer.write(XmlUtils.escape(value));
            } else if (escape && HtmlWriterUtil.attributeValueMustEscaped(name)) {
                this.attributeWriter.writeAttributeValue(value);
            } else {
                this.writer.write(value);
            }
            this.writer.write(34);
        }
    }

    public void writeAttribute(String name, Object value, String property, boolean escape) throws IOException {
        if (!this.startStillOpen) {
            String trace = this.getCallingClassStackTraceElementString();
            String error = "Cannot write attribute when start-tag not open. name = '" + name + "'" + "value = '" + value + "'" + "property = '" + property + "' " + trace.substring(trace.indexOf(40));
            LOG.error((Object)error);
            throw new IllegalStateException(error);
        }
        String attribute = this.findValue(value, property);
        if (attribute != null) {
            this.writer.write(32);
            this.writer.write(name);
            this.writer.write("=\"");
            if (this.xml) {
                this.writer.write(XmlUtils.escape(attribute));
            } else if (escape && HtmlWriterUtil.attributeValueMustEscaped(name)) {
                this.attributeWriter.writeAttributeValue(attribute);
            } else {
                this.writer.write(attribute);
            }
            this.writer.write(34);
        }
    }

    private String getCallingClassStackTraceElementString() {
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        int i = 1;
        while (stackTrace[i].getClassName().equals(((Object)((Object)this)).getClass().getName())) {
            ++i;
        }
        return stackTrace[i].toString();
    }

    public void writeIdAttribute(String id) throws IOException {
        this.writeAttribute("id", id, false);
    }

    public void writeNameAttribute(String id) throws IOException {
        this.writeAttribute("name", id, false);
    }

    public void writeClassAttribute(String id) throws IOException {
        this.writeAttribute("class", id, false);
    }

    public void writeComponentClass() throws IOException {
        this.writeComponentAttribute("class", "styleClass");
    }

    public void writeURIAttribute(String s, Object obj, String s1) throws IOException {
        LOG.error((Object)"Not implemented yet!");
    }
}

