/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.webapp;

import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.config.TobagoConfigParser;
import org.apache.myfaces.tobago.context.ResourceManagerFactory;

public class TobagoServletContextListener
implements ServletContextListener {
    private static final Log LOG = LogFactory.getLog(TobagoServletContextListener.class);

    public void contextInitialized(ServletContextEvent event) {
        block4: {
            ServletContext servletContext;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"*** contextInitialized ***");
            }
            if ((servletContext = event.getServletContext()).getAttribute("org.apache.myfaces.tobago.config.TobagoConfig") != null) {
                LOG.warn((Object)"Tobago has been already initialized. Do nothing.");
                return;
            }
            try {
                TobagoConfig tobagoConfig = new TobagoConfigParser().parse(servletContext);
                servletContext.setAttribute("org.apache.myfaces.tobago.config.TobagoConfig", (Object)tobagoConfig);
                ResourceManagerFactory.init(servletContext, tobagoConfig);
                tobagoConfig.resoveThemes();
                servletContext.setAttribute("org.apache.myfaces.tobago.config.ThemeConfig.CACHE", new HashMap());
            }
            catch (Throwable e) {
                if (!LOG.isFatalEnabled()) break block4;
                String error = "Error while deploy process. Tobago can't be initialized! Application will not run!";
                LOG.fatal((Object)error, e);
                throw new RuntimeException(error, e);
            }
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"*** contextDestroyed ***\n--- snip -----------------------------------------------------------------------");
        }
        ServletContext servletContext = event.getServletContext();
        servletContext.removeAttribute("org.apache.myfaces.tobago.config.TobagoConfig");
        ResourceManagerFactory.release(servletContext);
        servletContext.removeAttribute("org.apache.myfaces.tobago.config.ThemeConfig.CACHE");
        LogFactory.releaseAll();
    }
}

