package addressbook.web;

import org.apache.myfaces.tobago.model.PageStateImpl;

/**
 * Verwaltet Layoutinformationen für die Seite im Browser und macht es der
 * Anwendung möglich, auf Größenänderungen des Browserfensters zu reagieren.
 */
public class Layout extends PageStateImpl {

  private int margin = 10;
  private int width;
  private int height;
  private int minimumWidth;
  private int minimumHeight;

  public int getMargin() {
    return margin;
  }

  public void setMargin(int margin) {
    this.margin = margin;
  }

  public int getWidth() {
    int clientWidth = getClientWidth();
    if (clientWidth != 0) {
      if (clientWidth < minimumWidth) {
        return minimumWidth - 2*margin;
      }
      return clientWidth - 2*margin;
    }
    return width - 2*margin;
  }

  public void setWidth(int width) {
    this.width = width;
  }

  public int getHeight() {
    int clientHeight = getClientHeight();
    if (clientHeight != 0) {
      if (clientHeight < minimumHeight) {
        return minimumHeight - 2*margin;
      }
      return clientHeight - 2*margin;
    }
    return height - 2*margin;
  }

  public void setHeight(int height) {
    this.height = height;
  }

  public int getMinimumWidth() {
    return minimumWidth;
  }

  public void setMinimumWidth(int minimumWidth) {
    this.minimumWidth = minimumWidth;
  }

  public int getMinimumHeight() {
    return minimumHeight;
  }

  public void setMinimumHeight(int minimumHeight) {
    this.minimumHeight = minimumHeight;
  }

}
