
# Testausgaenge
PASS       = "PASS"
FAIL       = "FAIL"
UNRESOLVED = "UNRESOLVED"

# Hilfsfunktionen
from split import split
from listminus import listminus

def ddmin(eingabe, test):
    """Gibt eine Untermenge von EINGABE zurueck,
    deren Elemente fuer TEST relevant sind."""

    assert test([]) == PASS
    assert test(eingabe) == FAIL

    n = 2

    while len(eingabe) >= 2:
        untermengen = split(eingabe, n)
        assert len(untermengen) == n

        ein_komplement_schlaegt_fehl = 0
        for untermenge in untermengen:
            komplement = listminus(eingabe, untermenge)

            if test(komplement) == FAIL:
                eingabe = komplement
                n = max(n - 1, 2)
                ein_komplement_schlaegt_fehl = 1
                break

        if not ein_komplement_schlaegt_fehl:
            if n == len(eingabe):
                break
            n = min(n * 2, len(eingabe))

    return eingabe
