package aspects.persistence;

import java.util.ArrayList;
import java.util.List;

import messages.Message;
import client.Client;
import aspects.encryption.*;

public aspect Persistance {
	
	declare precedence: Encryption, Persistance;
 
	public List Client.getMessageHistory() {
		return messageHistory;
	}

	private void Client.loadMessageHistory() {
		// loads messages-List from disk
	}

	public void Client.addMessageToHistory(Message msg) {
		// adds the message to the list and writes it to the history on disk
	}

	private List<Message> Client.messageHistory;
	
	

	pointcut clientReceiveMessage(Message msg) : 
		execution(void Client.handleIncomingMessage(Message)) && args(msg);
	
	before(Message msg, Client client):clientReceiveMessage(msg) && target(client){
		client.messageHistory.add(msg);
	}
	
	before(Client client):execution(Client.new(..)) && target(client){
		client.messageHistory = new ArrayList<Message>();
		client.loadMessageHistory();
	}
	
	//TODO: extend gui with menu and history window
}
