package client;

/**
 * ChatClient.java  1.00 96/11/07 Merlin Hughes
 *
 * Copyright (c) 1996 Prominence Dot Com, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * for non-commercial purposes and without fee is hereby granted
 * provided that this copyright notice appears in all copies.
 *
 * http://prominence.com/                  merlin@prominence.com
 */

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;

import messages.Message;
import messages.TextMessage;

public class Client implements Runnable {
	protected ObjectInputStream i;

	protected ObjectOutputStream o;

	protected Thread listener;

	public Client(String host, int port) {
		try {
			System.out.println("Connecting to " + host + " (port " + port
					+ ")...");
			Socket s = new Socket(host, port);
			this.o = new ObjectOutputStream((s.getOutputStream()));
			this.i = new ObjectInputStream((s.getInputStream()));
			listener = new Thread(this);
			listener.start();
		} catch (UnknownHostException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}



	ArrayList<ChatLineListener> listners = new ArrayList<ChatLineListener>();

	void addLineListener(ChatLineListener listner) {
		listners.add(listner);
	}

	void removeLineListener(ChatLineListener listner) {
		listners.remove(listner);
	}

	void fireAddLine(String line) {
		for (ChatLineListener listener : listners) {
			listener.newChatLine(line);
		}
	}

	public void run() {
		try {
			while (true) {
				try {
					Object msg = i.readObject();
					if (msg instanceof Message)
						handleIncomingMessage((Message) msg);
				} catch (ClassNotFoundException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

			}
		} catch (IOException ex) {
			ex.printStackTrace();
		} finally {
			listener = null;
			try {
				o.close();
			} catch (IOException ex) {
				ex.printStackTrace();
			}
		}
	}

	protected void handleIncomingMessage(Message msg) {
		if (msg instanceof TextMessage) {
			fireAddLine(((TextMessage) msg).content + "\n");
		}
	}

	public static void main(String args[]) throws IOException {
		if (args.length != 2)
			throw new RuntimeException("Syntax: ChatClient <host> <port>");

		Client client = new Client(args[0], Integer.parseInt(args[1]));
		new Gui("Chat " + args[0] + ":" + args[1], client);
	}

	@SuppressWarnings("deprecation")
	public void stop() {
		listener.stop();
	}

	public void send(String line) {
		send(new TextMessage(line));
	}

	@SuppressWarnings("deprecation")
	public void send(Message msg) {
		try {
			o.writeObject(msg);
			o.flush();
		} catch (IOException ex) {
			ex.printStackTrace();
			listener.stop();
		}
	}


}
