package client;
import java.awt.BorderLayout;
import java.awt.Event;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.TextField;

public class Gui extends Frame implements ChatLineListener{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	protected TextArea output;

	protected TextField input;

	private Client client;
	
	public Gui(String title, Client client) {
		super(title);
		System.out.println("starting gui...");
		setLayout(new BorderLayout());
		add("Center", output = new TextArea());
		output.setEditable(false);
		add("South", input = new TextField());
		pack();
		setVisible(true);
		input.requestFocus();
		
		client.addLineListener(this);
		this.client=client;
	}

	public void newChatLine(String line) {
		output.append(line);
	}
	
	public boolean handleEvent(Event e) {
		if ((e.target == input) && (e.id == Event.ACTION_EVENT)) {
				client.send((String) e.arg);
			input.setText("");
			return true;
		} else if ((e.target == this) && (e.id == Event.WINDOW_DESTROY)) {
			if (client != null)
				client.stop();
			setVisible(false);
			System.exit(0);
			return true;
		}
		return super.handleEvent(e);
	}
}
