package server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;

import messages.Message;
import messages.TextMessage;

public class ServerConnection extends Thread {
	protected Socket s;

	protected ObjectInputStream i;

	protected ObjectOutputStream o;

	private Server server;

	private String name;

	public ServerConnection(Socket s, Server server) {
		this.s = s;
		try {
			i = new ObjectInputStream((s.getInputStream()));
			o = new ObjectOutputStream((s.getOutputStream()));
		} catch (IOException e) {
			e.printStackTrace();
		}

		this.server = server;
	}

	public void run() {
		name = s.getInetAddress().toString();
		try {
			server.broadcast(name + " has joined.");
			while (true) {

				try {
					Object msg = i.readObject();
					if (msg instanceof Message)
						handleIncomingMessage((Message) msg);
				} catch (ClassNotFoundException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

			}
		} catch (IOException ex) {
			ex.printStackTrace();
		} finally {
			close();
			server.broadcast(name + " has left.");
			try {
				s.close();
			} catch (IOException ex) {
				ex.printStackTrace();
			}
		}
	}

	private void handleIncomingMessage(Message msg) {
		if (msg instanceof TextMessage)
			server.broadcast(name + " - " + ((TextMessage) msg).content);
	}

	public void send(String line) {
		send(new TextMessage(line));
	}

	@SuppressWarnings("deprecation")
	public void send(Message msg) {
		try {
			synchronized (o) {
				o.writeObject(msg);
			}
			o.flush();
		} catch (IOException ex) {
			stop();
		}

	}

	protected void close() {
		server.removeConnection(this);
	}

}
