package encryption;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Key;
import java.util.StringTokenizer;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

import messages.EncryptedMessage;
import messages.Message;

public class MessageSymmetricEncrypter {
	private static final String KEY_STRING = "193-155-248-97-234-56-100-241";

	protected static Key getKey() {
		try {
			byte[] bytes = getBytes(KEY_STRING);
			DESKeySpec pass = new DESKeySpec(bytes);
			SecretKeyFactory skf = SecretKeyFactory.getInstance("DES");
			SecretKey s = skf.generateSecret(pass);
			return s;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	protected static byte[] getBytes(String str) {
		ByteArrayOutputStream bos = new ByteArrayOutputStream();
		StringTokenizer st = new StringTokenizer(str, "-", false);
		while (st.hasMoreTokens()) {
			int i = Integer.parseInt(st.nextToken());
			bos.write((byte) i);
		}
		return bos.toByteArray();
	}

	protected static byte[] encrypt(byte[] cleartext) {
		try {
			// Get our secret key
			Key key = getKey();

			// Create the cipher
			Cipher desCipher = Cipher.getInstance("DES/ECB/PKCS5Padding");

			// Initialize the cipher for encryption
			desCipher.init(Cipher.ENCRYPT_MODE, key);

			// Encrypt the cleartext
			byte[] ciphertext = desCipher.doFinal(cleartext);

			// Return a String representation of the cipher text
			return ciphertext;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	protected static byte[] decrypt(byte[] ciphertext) {
		try {
			// Get our secret key
			Key key = getKey();

			// Create the cipher
			Cipher desCipher = Cipher.getInstance("DES/ECB/PKCS5Padding");

			// Initialize the same cipher for decryption
			desCipher.init(Cipher.DECRYPT_MODE, key);

			// Decrypt the ciphertext
			byte[] cleartext = desCipher.doFinal(ciphertext);

			// Return the clear text
			return cleartext;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public static EncryptedMessage encryptMessage(Message msg) {

		ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
		try {
			ObjectOutputStream objectOutput = new ObjectOutputStream(byteOutput);

			objectOutput.writeObject(msg);
			objectOutput.close();

		} catch (IOException e) {
			e.printStackTrace();
		}

		byte[] encryptedObject = encrypt(byteOutput.toByteArray());

		return new EncryptedMessage(encryptedObject);
	}

	public static Message decryptMessage(EncryptedMessage msg) {
		byte[] decryptedData = decrypt(msg.encryptedMessage);
		ByteArrayInputStream byteInput = new ByteArrayInputStream(decryptedData);
		Message decryptedMessage = null;
		try {
			ObjectInputStream objectInput = new ObjectInputStream(byteInput);

			decryptedMessage = (Message) objectInput.readObject();
		} catch (IOException e) {
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		}
		return decryptedMessage;
	}

}
