/*
 * <copyright>
 *
 * Copyright (c) 2005-2006 Markus Voelter and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Voelter - Initial API and implementation
 *
 * </copyright>
 */
package org.openarchitectureware.recipe.util;

import java.util.Iterator;
import java.util.List;

import org.openarchitectureware.recipe.core.AtomicCheck;
import org.openarchitectureware.recipe.core.EvalStatus;
import org.openarchitectureware.recipe.core.EvalTrigger;
import org.openarchitectureware.recipe.core.EvaluationStop;
import org.openarchitectureware.recipe.eval.EvaluationContext;

public abstract class EclipseCheck extends AtomicCheck {

	private static final long serialVersionUID = 1L;
	private static List classlaoders;
	
	public EclipseCheck( String name, String description, int trigger ) {
		super(name, description, trigger);
	}
	
	public EclipseCheck( String name, String description ) {
		this(name, description, EvalTrigger.ON_REQUEST);
	}	
	
	public static void setClassloaders( List list ) {
		classlaoders = list;
	}
	
	
	public final void evaluate(EvaluationContext ctx) {
		if ( ctx.evaluateBatchOnly() ) {
			setStatus( EvalStatus.SKIPPED );
			setStatusMessage( "skipped - mode was batch only." );
			return;
		}
		String cn = this.getClass().getName();
		Class cls = null;
		try {
			cls = resolveClass( cn+"Evaluator" );
			if ( cls == null ) {
				fail("ERROR: cannot load evaluator class: "+cn);
			}
		} catch ( Throwable t ) {
			fail("ERROR: cannot load evaluator class: "+cn);
		}
		Object o = null;
		try {
			o = cls.newInstance();
		} catch ( Throwable t ) {
			fail("ERROR: cannot instantiate evaluator class: "+cn);
		}
		try {
			ICheckEvaluator eval = (ICheckEvaluator)o;
			eval.evaluate(this);
		} catch ( ClassCastException t ) {
			fail("ERROR: cannot cast evaluator object to ICheckEvaluator");
		} catch ( EvaluationStop t ) {
			throw t;
		}
	}

	private Class resolveClass(String cn) {
		for (Iterator iter = classlaoders.iterator(); iter.hasNext();) {
			ClassLoader cl = (ClassLoader) iter.next();
			try {
				Class cls = cl.loadClass( cn );
				if ( cls != null ) return cls;
			} catch (ClassNotFoundException ignore) {}
		}
		return null;
	}

	public boolean isInteractive() {
		return true;
	}
	
}
