/*
 * <copyright>
 *
 * Copyright (c) 2005-2006 Markus Voelter and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Voelter - Initial API and implementation
 *
 * </copyright>
 */
package org.openarchitectureware.recipe.checks.file;

import java.io.File;

import org.openarchitectureware.recipe.core.AtomicCheck;
import org.openarchitectureware.recipe.eval.EvaluationContext;

public class FileExistenceCheck extends AtomicCheck {

	protected String absoluteFileName;

	public FileExistenceCheck( String message, String absoluteFileName ) {
		super( "file exists", message );
		setAbsoluteFileName( absoluteFileName );
	}
	
	protected void setAbsoluteFileName(String fn) {
		this.absoluteFileName = fn;
		setParameter( "file name", absoluteFileName );
	}

	public void evaluate(EvaluationContext ctx) {
		if ( new File( absoluteFileName ).exists() ) ok();
		else fail("file not found: "+absoluteFileName);
	}

}
