package statemachine2.diagram.edit.parts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.StackLayout;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;

import org.eclipse.gef.commands.Command;

import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;

import org.eclipse.gef.requests.CreateRequest;

import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;

import org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles;

import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;

import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;

import org.eclipse.gmf.runtime.notation.View;

import statemachine2.diagram.edit.policies.StartState2CanonicalEditPolicy;
import statemachine2.diagram.edit.policies.StartState2GraphicalNodeEditPolicy;
import statemachine2.diagram.edit.policies.StartState2ItemSemanticEditPolicy;

/**
 * @generated
 */
public class StartState2EditPart extends ShapeNodeEditPart {

	/**
	 * @generated
	 */
	public static final int VISUAL_ID = 2003;

	/**
	 * @generated
	 */
	protected IFigure contentPane;

	/**
	 * @generated
	 */
	protected IFigure primaryShape;

	/**
	 * @generated
	 */
	public StartState2EditPart(View view) {
		super(view);
	}

	/**
	 * @generated
	 */
	protected void createDefaultEditPolicies() {
		super.createDefaultEditPolicies();
		installEditPolicy(EditPolicyRoles.SEMANTIC_ROLE,
				new StartState2ItemSemanticEditPolicy());
		installEditPolicy(EditPolicy.GRAPHICAL_NODE_ROLE,
				new StartState2GraphicalNodeEditPolicy());
		installEditPolicy(EditPolicyRoles.CANONICAL_ROLE,
				new StartState2CanonicalEditPolicy());
		installEditPolicy(EditPolicy.LAYOUT_ROLE, createLayoutEditPolicy());
	}

	/**
	 * @generated
	 */
	protected LayoutEditPolicy createLayoutEditPolicy() {
		LayoutEditPolicy lep = new LayoutEditPolicy() {

			protected EditPolicy createChildEditPolicy(EditPart child) {
				EditPolicy result = child
						.getEditPolicy(EditPolicy.PRIMARY_DRAG_ROLE);
				if (result == null) {
					result = new NonResizableEditPolicy();
				}
				return result;
			}

			protected Command getMoveChildrenCommand(Request request) {
				return null;
			}

			protected Command getCreateCommand(CreateRequest request) {
				return null;
			}
		};
		return lep;
	}

	/**
	 * @generated
	 */
	protected IFigure createNodeShape() {
		StartStateRect figure = new StartStateRect();
		return primaryShape = figure;
	}

	/**
	 * @generated
	 */
	public StartStateRect getPrimaryShape() {
		return (StartStateRect) primaryShape;
	}

	/**
	 * @generated
	 */
	protected NodeFigure createNodePlate() {
		return new DefaultSizeNodeFigure(getMapMode().DPtoLP(40), getMapMode()
				.DPtoLP(40));
	}

	/**
	 * @generated
	 */
	public EditPolicy getPrimaryDragEditPolicy() {
		ResizableEditPolicy ep = (ResizableEditPolicy) super
				.getPrimaryDragEditPolicy();

		ep.setResizeDirections(PositionConstants.NORTH
				| PositionConstants.SOUTH | PositionConstants.WEST
				| PositionConstants.EAST);

		return ep;
	}

	/**
	 * Creates figure for this edit part.
	 * 
	 * Body of this method does not depend on settings in generation model
	 * so you may safely remove <i>generated</i> tag and modify it.
	 * 
	 * @generated
	 */
	protected NodeFigure createNodeFigure() {
		NodeFigure figure = createNodePlate();
		figure.setLayoutManager(new StackLayout());
		IFigure shape = createNodeShape();
		figure.add(shape);
		contentPane = setupContentPane(shape);
		return figure;
	}

	/**
	 * Default implementation treats passed figure as content pane.
	 * Respects layout one may have set for generated figure.
	 * @param nodeShape instance of generated figure class
	 * @generated
	 */
	protected IFigure setupContentPane(IFigure nodeShape) {
		if (nodeShape.getLayoutManager() == null) {
			ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
			layout.setSpacing(getMapMode().DPtoLP(5));
			nodeShape.setLayoutManager(layout);
		}
		return nodeShape; // use nodeShape itself as contentPane
	}

	/**
	 * @generated
	 */
	public IFigure getContentPane() {
		if (contentPane != null) {
			return contentPane;
		}
		return super.getContentPane();
	}

	/**
	 * @generated
	 */
	public class StartStateRect extends org.eclipse.draw2d.RectangleFigure {

		/**
		 * @generated
		 */
		public StartStateRect() {

			org.eclipse.draw2d.BorderLayout myGenLayoutManager = new org.eclipse.draw2d.BorderLayout();

			this.setLayoutManager(myGenLayoutManager);

			this.setOutline(false);

			org.eclipse.draw2d.Ellipse childStartStateEllipse = createFigureStartStateEllipse();
			setFigureStartStateEllipse(childStartStateEllipse);
			add(childStartStateEllipse);

			myGenLayoutManager.setConstraint(childStartStateEllipse,
					org.eclipse.draw2d.BorderLayout.CENTER);

			org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel childStartStateNameLabel = createFigureStartStateNameLabel();
			setFigureStartStateNameLabel(childStartStateNameLabel);
			add(childStartStateNameLabel);

			myGenLayoutManager.setConstraint(childStartStateNameLabel,
					org.eclipse.draw2d.BorderLayout.BOTTOM);

		}

		/**
		 * @generated
		 */
		private org.eclipse.draw2d.Ellipse fStartStateEllipse;

		/**
		 * @generated
		 */
		public org.eclipse.draw2d.Ellipse getFigureStartStateEllipse() {
			return fStartStateEllipse;
		}

		/**
		 * @generated
		 */
		protected void setFigureStartStateEllipse(
				org.eclipse.draw2d.Ellipse figure) {
			fStartStateEllipse = figure;
		}

		/**
		 * @generated
		 */
		private org.eclipse.draw2d.Ellipse createFigureStartStateEllipse() {
			org.eclipse.draw2d.Ellipse StartStateEllipse = new org.eclipse.draw2d.Ellipse();

			StartStateEllipse.setOutline(false);
			StartStateEllipse.setLineWidth(2);
			StartStateEllipse
					.setBackgroundColor(new org.eclipse.swt.graphics.Color(
							null, 0, 0, 0));

			return StartStateEllipse;
		}

		/**
		 * @generated
		 */
		private org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel fStartStateNameLabel;

		/**
		 * @generated
		 */
		public org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel getFigureStartStateNameLabel() {
			return fStartStateNameLabel;
		}

		/**
		 * @generated
		 */
		protected void setFigureStartStateNameLabel(
				org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel figure) {
			fStartStateNameLabel = figure;
		}

		/**
		 * @generated
		 */
		private org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel createFigureStartStateNameLabel() {
			org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel StartStateNameLabel = new org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel();
			StartStateNameLabel.setText("StartState");

			return StartStateNameLabel;
		}

		/**
		 * @generated
		 */
		private boolean myUseLocalCoordinates = false;

		/**
		 * @generated
		 */
		protected boolean useLocalCoordinates() {
			return myUseLocalCoordinates;
		}

		/**
		 * @generated
		 */
		protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
			myUseLocalCoordinates = useLocalCoordinates;
		}

	}

}
