package statemachine2.diagram.edit.parts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.StackLayout;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;

import org.eclipse.gef.commands.Command;

import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;

import org.eclipse.gef.requests.CreateRequest;

import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;

import org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles;

import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;

import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;

import org.eclipse.gmf.runtime.notation.View;

import statemachine2.diagram.edit.policies.StopState2CanonicalEditPolicy;
import statemachine2.diagram.edit.policies.StopState2GraphicalNodeEditPolicy;
import statemachine2.diagram.edit.policies.StopState2ItemSemanticEditPolicy;

import statemachine2.diagram.part.Statemachine2VisualIDRegistry;

/**
 * @generated
 */
public class StopState2EditPart extends ShapeNodeEditPart {

	/**
	 * @generated
	 */
	public static final int VISUAL_ID = 2004;

	/**
	 * @generated
	 */
	protected IFigure contentPane;

	/**
	 * @generated
	 */
	protected IFigure primaryShape;

	/**
	 * @generated
	 */
	public StopState2EditPart(View view) {
		super(view);
	}

	/**
	 * @generated
	 */
	protected void createDefaultEditPolicies() {
		super.createDefaultEditPolicies();
		installEditPolicy(EditPolicyRoles.SEMANTIC_ROLE,
				new StopState2ItemSemanticEditPolicy());
		installEditPolicy(EditPolicy.GRAPHICAL_NODE_ROLE,
				new StopState2GraphicalNodeEditPolicy());
		installEditPolicy(EditPolicyRoles.CANONICAL_ROLE,
				new StopState2CanonicalEditPolicy());
		installEditPolicy(EditPolicy.LAYOUT_ROLE, createLayoutEditPolicy());
	}

	/**
	 * @generated
	 */
	protected LayoutEditPolicy createLayoutEditPolicy() {
		LayoutEditPolicy lep = new LayoutEditPolicy() {

			protected EditPolicy createChildEditPolicy(EditPart child) {
				EditPolicy result = child
						.getEditPolicy(EditPolicy.PRIMARY_DRAG_ROLE);
				if (result == null) {
					result = new NonResizableEditPolicy();
				}
				return result;
			}

			protected Command getMoveChildrenCommand(Request request) {
				return null;
			}

			protected Command getCreateCommand(CreateRequest request) {
				return null;
			}
		};
		return lep;
	}

	/**
	 * @generated
	 */
	protected IFigure createNodeShape() {
		StopStateRect figure = new StopStateRect();
		return primaryShape = figure;
	}

	/**
	 * @generated
	 */
	public StopStateRect getPrimaryShape() {
		return (StopStateRect) primaryShape;
	}

	/**
	 * @generated
	 */
	protected NodeFigure createNodePlate() {
		return new DefaultSizeNodeFigure(getMapMode().DPtoLP(40), getMapMode()
				.DPtoLP(40));
	}

	/**
	 * @generated
	 */
	public EditPolicy getPrimaryDragEditPolicy() {
		ResizableEditPolicy ep = (ResizableEditPolicy) super
				.getPrimaryDragEditPolicy();

		ep.setResizeDirections(PositionConstants.NORTH
				| PositionConstants.SOUTH | PositionConstants.WEST
				| PositionConstants.EAST);

		return ep;
	}

	/**
	 * Creates figure for this edit part.
	 * 
	 * Body of this method does not depend on settings in generation model
	 * so you may safely remove <i>generated</i> tag and modify it.
	 * 
	 * @generated
	 */
	protected NodeFigure createNodeFigure() {
		NodeFigure figure = createNodePlate();
		figure.setLayoutManager(new StackLayout());
		IFigure shape = createNodeShape();
		figure.add(shape);
		contentPane = setupContentPane(shape);
		return figure;
	}

	/**
	 * Default implementation treats passed figure as content pane.
	 * Respects layout one may have set for generated figure.
	 * @param nodeShape instance of generated figure class
	 * @generated
	 */
	protected IFigure setupContentPane(IFigure nodeShape) {
		if (nodeShape.getLayoutManager() == null) {
			ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
			layout.setSpacing(getMapMode().DPtoLP(5));
			nodeShape.setLayoutManager(layout);
		}
		return nodeShape; // use nodeShape itself as contentPane
	}

	/**
	 * @generated
	 */
	public IFigure getContentPane() {
		if (contentPane != null) {
			return contentPane;
		}
		return super.getContentPane();
	}

	/**
	 * @generated
	 */
	public EditPart getPrimaryChildEditPart() {
		return getChildBySemanticHint(Statemachine2VisualIDRegistry
				.getType(StopState_name2EditPart.VISUAL_ID));
	}

	/**
	 * @generated
	 */
	public class StopStateRect extends org.eclipse.draw2d.RectangleFigure {

		/**
		 * @generated
		 */
		public StopStateRect() {

			org.eclipse.draw2d.BorderLayout myGenLayoutManager = new org.eclipse.draw2d.BorderLayout();

			this.setLayoutManager(myGenLayoutManager);

			this.setOutline(false);

			org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel childStopStateNameLabel = createFigureStopStateNameLabel();
			setFigureStopStateNameLabel(childStopStateNameLabel);
			add(childStopStateNameLabel);

			myGenLayoutManager.setConstraint(childStopStateNameLabel,
					org.eclipse.draw2d.BorderLayout.BOTTOM);

			org.eclipse.draw2d.Ellipse childouterEllipse = createFigureouterEllipse();
			setFigureouterEllipse(childouterEllipse);
			add(childouterEllipse);

			myGenLayoutManager.setConstraint(childouterEllipse,
					org.eclipse.draw2d.BorderLayout.CENTER);

		}

		/**
		 * @generated
		 */
		private org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel fStopStateNameLabel;

		/**
		 * @generated
		 */
		public org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel getFigureStopStateNameLabel() {
			return fStopStateNameLabel;
		}

		/**
		 * @generated
		 */
		protected void setFigureStopStateNameLabel(
				org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel figure) {
			fStopStateNameLabel = figure;
		}

		/**
		 * @generated
		 */
		private org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel createFigureStopStateNameLabel() {
			org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel StopStateNameLabel = new org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel();
			StopStateNameLabel.setText("StopState");

			return StopStateNameLabel;
		}

		/**
		 * @generated
		 */
		private org.eclipse.draw2d.Ellipse fouterEllipse;

		/**
		 * @generated
		 */
		public org.eclipse.draw2d.Ellipse getFigureouterEllipse() {
			return fouterEllipse;
		}

		/**
		 * @generated
		 */
		protected void setFigureouterEllipse(org.eclipse.draw2d.Ellipse figure) {
			fouterEllipse = figure;
		}

		/**
		 * @generated
		 */
		private org.eclipse.draw2d.Ellipse createFigureouterEllipse() {
			org.eclipse.draw2d.Ellipse outerEllipse = new org.eclipse.draw2d.Ellipse();

			outerEllipse.setPreferredSize(getMapMode().DPtoLP(60), getMapMode()
					.DPtoLP(60));
			outerEllipse
					.setMaximumSize(new org.eclipse.draw2d.geometry.Dimension(
							getMapMode().DPtoLP(80), getMapMode().DPtoLP(80)));
			outerEllipse
					.setMinimumSize(new org.eclipse.draw2d.geometry.Dimension(
							getMapMode().DPtoLP(60), getMapMode().DPtoLP(60)));
			outerEllipse.setBorder(new org.eclipse.draw2d.MarginBorder(
					getMapMode().DPtoLP(5), getMapMode().DPtoLP(5),
					getMapMode().DPtoLP(5), getMapMode().DPtoLP(5)));

			org.eclipse.draw2d.BorderLayout layoutManagerouterEllipse = new org.eclipse.draw2d.BorderLayout();

			outerEllipse.setLayoutManager(layoutManagerouterEllipse);

			org.eclipse.draw2d.Ellipse fig_0 = new org.eclipse.draw2d.Ellipse();

			fig_0.setFillXOR(true);
			fig_0.setBackgroundColor(org.eclipse.draw2d.ColorConstants.black);

			outerEllipse.add(fig_0);

			layoutManagerouterEllipse.setConstraint(fig_0,
					org.eclipse.draw2d.BorderLayout.CENTER);

			return outerEllipse;
		}

		/**
		 * @generated
		 */
		private boolean myUseLocalCoordinates = false;

		/**
		 * @generated
		 */
		protected boolean useLocalCoordinates() {
			return myUseLocalCoordinates;
		}

		/**
		 * @generated
		 */
		protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
			myUseLocalCoordinates = useLocalCoordinates;
		}

	}

}
