package statemachine2.diagram.providers;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import statemachine2.Statemachine2Package;

import statemachine2.diagram.part.Statemachine2DiagramEditorPlugin;

/**
 * @generated
 */
public class Statemachine2ElementTypes {

	/**
	 * @generated
	 */
	private Statemachine2ElementTypes() {
	}

	/**
	 * @generated
	 */
	private static Map elements;

	/**
	 * @generated
	 */
	private static ImageRegistry imageRegistry;

	/**
	 * @generated
	 */
	private static ImageRegistry getImageRegistry() {
		if (imageRegistry == null) {
			imageRegistry = new ImageRegistry();
		}
		return imageRegistry;
	}

	/**
	 * @generated
	 */
	private static String getImageRegistryKey(ENamedElement element) {
		return element.getName();
	}

	/**
	 * @generated
	 */
	private static ImageDescriptor getProvidedImageDescriptor(
			ENamedElement element) {
		if (element instanceof EStructuralFeature) {
			element = ((EStructuralFeature) element).getEContainingClass();
		}
		if (element instanceof EClass) {
			EClass eClass = (EClass) element;
			if (!eClass.isAbstract()) {
				return Statemachine2DiagramEditorPlugin.getInstance()
						.getItemImageDescriptor(
								eClass.getEPackage().getEFactoryInstance()
										.create(eClass));
			}
		}
		// TODO : support structural features
		return null;
	}

	/**
	 * @generated
	 */
	public static ImageDescriptor getImageDescriptor(ENamedElement element) {
		String key = getImageRegistryKey(element);
		ImageDescriptor imageDescriptor = getImageRegistry().getDescriptor(key);
		if (imageDescriptor == null) {
			imageDescriptor = getProvidedImageDescriptor(element);
			if (imageDescriptor == null) {
				imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
			}
			getImageRegistry().put(key, imageDescriptor);
		}
		return imageDescriptor;
	}

	/**
	 * @generated
	 */
	public static Image getImage(ENamedElement element) {
		String key = getImageRegistryKey(element);
		Image image = getImageRegistry().get(key);
		if (image == null) {
			ImageDescriptor imageDescriptor = getProvidedImageDescriptor(element);
			if (imageDescriptor == null) {
				imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
			}
			getImageRegistry().put(key, imageDescriptor);
			image = getImageRegistry().get(key);
		}
		return image;
	}

	/**
	 * @generated
	 */
	public static ImageDescriptor getImageDescriptor(IAdaptable hint) {
		ENamedElement element = getElement(hint);
		if (element == null) {
			return null;
		}
		return getImageDescriptor(element);
	}

	/**
	 * @generated
	 */
	public static Image getImage(IAdaptable hint) {
		ENamedElement element = getElement(hint);
		if (element == null) {
			return null;
		}
		return getImage(element);
	}

	/**
	 * Returns 'type' of the ecore object associated with the hint.
	 * 
	 * @generated
	 */
	public static ENamedElement getElement(IAdaptable hint) {
		Object type = hint.getAdapter(IElementType.class);
		if (elements == null) {
			elements = new IdentityHashMap();
			elements.put(StateMachine_79, Statemachine2Package.eINSTANCE
					.getStateMachine());
			elements.put(Action_2001, Statemachine2Package.eINSTANCE
					.getAction());
			elements.put(State_2002, Statemachine2Package.eINSTANCE.getState());
			elements.put(StartState_2003, Statemachine2Package.eINSTANCE
					.getStartState());
			elements.put(StopState_2004, Statemachine2Package.eINSTANCE
					.getStopState());
			elements.put(CompositeState_2005, Statemachine2Package.eINSTANCE
					.getCompositeState());
			elements.put(Action_2006, Statemachine2Package.eINSTANCE
					.getAction());
			elements.put(State_1001, Statemachine2Package.eINSTANCE.getState());
			elements.put(StartState_1002, Statemachine2Package.eINSTANCE
					.getStartState());
			elements.put(StopState_1003, Statemachine2Package.eINSTANCE
					.getStopState());
			elements.put(CompositeState_1004, Statemachine2Package.eINSTANCE
					.getCompositeState());
			elements.put(Transition_3001, Statemachine2Package.eINSTANCE
					.getTransition());
		}
		return (ENamedElement) elements.get(type);
	}

	/**
	 * @generated
	 */
	public static final IElementType StateMachine_79 = getElementType("oaw4.demo.gmf.statemachine2.diagram.StateMachine_79"); //$NON-NLS-1$

	/**
	 * @generated
	 */
	public static final IElementType Action_2001 = getElementType("oaw4.demo.gmf.statemachine2.diagram.Action_2001"); //$NON-NLS-1$

	/**
	 * @generated
	 */
	public static final IElementType State_2002 = getElementType("oaw4.demo.gmf.statemachine2.diagram.State_2002"); //$NON-NLS-1$

	/**
	 * @generated
	 */
	public static final IElementType StartState_2003 = getElementType("oaw4.demo.gmf.statemachine2.diagram.StartState_2003"); //$NON-NLS-1$

	/**
	 * @generated
	 */
	public static final IElementType StopState_2004 = getElementType("oaw4.demo.gmf.statemachine2.diagram.StopState_2004"); //$NON-NLS-1$

	/**
	 * @generated
	 */
	public static final IElementType CompositeState_2005 = getElementType("oaw4.demo.gmf.statemachine2.diagram.CompositeState_2005"); //$NON-NLS-1$

	/**
	 * @generated
	 */
	public static final IElementType Action_2006 = getElementType("oaw4.demo.gmf.statemachine2.diagram.Action_2006"); //$NON-NLS-1$

	/**
	 * @generated
	 */
	public static final IElementType State_1001 = getElementType("oaw4.demo.gmf.statemachine2.diagram.State_1001"); //$NON-NLS-1$

	/**
	 * @generated
	 */
	public static final IElementType StartState_1002 = getElementType("oaw4.demo.gmf.statemachine2.diagram.StartState_1002"); //$NON-NLS-1$

	/**
	 * @generated
	 */
	public static final IElementType StopState_1003 = getElementType("oaw4.demo.gmf.statemachine2.diagram.StopState_1003"); //$NON-NLS-1$

	/**
	 * @generated
	 */
	public static final IElementType CompositeState_1004 = getElementType("oaw4.demo.gmf.statemachine2.diagram.CompositeState_1004"); //$NON-NLS-1$

	/**
	 * @generated
	 */
	public static final IElementType Transition_3001 = getElementType("oaw4.demo.gmf.statemachine2.diagram.Transition_3001"); //$NON-NLS-1$

	/**
	 * @generated
	 */
	private static IElementType getElementType(String id) {
		return ElementTypeRegistry.getInstance().getType(id);
	}

	/**
	 * @generated
	 */
	private static Set KNOWN_ELEMENT_TYPES;

	/**
	 * @generated
	 */
	public static boolean isKnownElementType(IElementType elementType) {
		if (KNOWN_ELEMENT_TYPES == null) {
			KNOWN_ELEMENT_TYPES = new HashSet();
			KNOWN_ELEMENT_TYPES.add(StateMachine_79);
			KNOWN_ELEMENT_TYPES.add(Action_2001);
			KNOWN_ELEMENT_TYPES.add(State_2002);
			KNOWN_ELEMENT_TYPES.add(StartState_2003);
			KNOWN_ELEMENT_TYPES.add(StopState_2004);
			KNOWN_ELEMENT_TYPES.add(CompositeState_2005);
			KNOWN_ELEMENT_TYPES.add(Action_2006);
			KNOWN_ELEMENT_TYPES.add(State_1001);
			KNOWN_ELEMENT_TYPES.add(StartState_1002);
			KNOWN_ELEMENT_TYPES.add(StopState_1003);
			KNOWN_ELEMENT_TYPES.add(CompositeState_1004);
			KNOWN_ELEMENT_TYPES.add(Transition_3001);
		}
		return KNOWN_ELEMENT_TYPES.contains(elementType);
	}
}
