package de.jax;

public abstract class AbstractCdPlayer implements CdPlayerActions {
    private CdPlayerStates currentState = CdPlayerStates.OFF;
    private boolean terminated = false;

    public void handleEvent(CdPlayerEvents event) {
        if (terminated) {
            throw new RuntimeException("this sm is terminated!");
        }

        switch (currentState) {
        case OFF:

            if (event == CdPlayerEvents.ERROR) {
                currentState = CdPlayerStates.EMERGENCYSHUTDOWN;

                System.out.println("Executing transition to EmergencyShutDown");

                break;
            }

            if (event == CdPlayerEvents.POWERSWITCHPRESSED) {
                this.checkCD();
                this.stopPlaying();

                currentState = CdPlayerStates.STOP;

                System.out.println("Executing transition to Stop");

                break;
            }

            throw new RuntimeException("Illegal Transition");

        case STOP:

            if (event == CdPlayerEvents.PLAYPRESSED) {
                this.startPlaying();

                currentState = CdPlayerStates.PLAY;

                System.out.println("Executing transition to Play");

                break;
            }

            if (event == CdPlayerEvents.OPENCLOSEPRESSED) {
                this.openTray();

                currentState = CdPlayerStates.OPEN;

                System.out.println("Executing transition to Open");

                break;
            }

            if (event == CdPlayerEvents.ERROR) {
                currentState = CdPlayerStates.EMERGENCYSHUTDOWN;

                System.out.println("Executing transition to EmergencyShutDown");

                break;
            }

            if (event == CdPlayerEvents.POWERSWITCHPRESSED) {
                this.shutDown();

                currentState = CdPlayerStates.OFF;

                System.out.println("Executing transition to Off");

                break;
            }

            throw new RuntimeException("Illegal Transition");

        case EMERGENCYSHUTDOWN:
            throw new RuntimeException("Illegal Transition");

        case PLAY:

            if (event == CdPlayerEvents.STOPPRESSED) {
                this.stopPlaying();

                currentState = CdPlayerStates.STOP;

                System.out.println("Executing transition to Stop");

                break;
            }

            if (event == CdPlayerEvents.OPENCLOSEPRESSED) {
                this.openTray();

                currentState = CdPlayerStates.OPEN;

                System.out.println("Executing transition to Open");

                break;
            }

            if (event == CdPlayerEvents.PAUSEPRESSED) {
                this.pausePlaying();

                currentState = CdPlayerStates.PAUSE;

                System.out.println("Executing transition to Pause");

                break;
            }

            if (event == CdPlayerEvents.ERROR) {
                currentState = CdPlayerStates.EMERGENCYSHUTDOWN;

                System.out.println("Executing transition to EmergencyShutDown");

                break;
            }

            if (event == CdPlayerEvents.POWERSWITCHPRESSED) {
                this.shutDown();

                currentState = CdPlayerStates.OFF;

                System.out.println("Executing transition to Off");

                break;
            }

            throw new RuntimeException("Illegal Transition");

        case OPEN:

            if (event == CdPlayerEvents.ERROR) {
                this.closeTray();

                currentState = CdPlayerStates.EMERGENCYSHUTDOWN;

                System.out.println("Executing transition to EmergencyShutDown");

                break;
            }

            if (event == CdPlayerEvents.OPENCLOSEPRESSED) {
                this.checkCD();
                this.closeTray();
                this.stopPlaying();

                currentState = CdPlayerStates.STOP;

                System.out.println("Executing transition to Stop");

                break;
            }

            throw new RuntimeException("Illegal Transition");

        case PAUSE:

            if (event == CdPlayerEvents.STOPPRESSED) {
                this.stopPlaying();

                currentState = CdPlayerStates.STOP;

                System.out.println("Executing transition to Stop");

                break;
            }

            if (event == CdPlayerEvents.ERROR) {
                currentState = CdPlayerStates.EMERGENCYSHUTDOWN;

                System.out.println("Executing transition to EmergencyShutDown");

                break;
            }

            if (event == CdPlayerEvents.OPENCLOSEPRESSED) {
                this.openTray();

                currentState = CdPlayerStates.OPEN;

                System.out.println("Executing transition to Open");

                break;
            }

            if (event == CdPlayerEvents.PAUSEPRESSED) {
                this.startPlaying();

                currentState = CdPlayerStates.PLAY;

                System.out.println("Executing transition to Play");

                break;
            }

            if (event == CdPlayerEvents.POWERSWITCHPRESSED) {
                this.shutDown();

                currentState = CdPlayerStates.OFF;

                System.out.println("Executing transition to Off");

                break;
            }

            throw new RuntimeException("Illegal Transition");
        }
    }

    public CdPlayerStates getCurrentState() {
        return currentState;
    }
}
