package de.jax;

import junit.framework.TestCase;

public class CdPlayerTest extends TestCase {

	private CdPlayer player;

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		player = new CdPlayer();
	}
	
	public void testStatemachine() {
		assertEquals(CdPlayerStates.OFF, player.getCurrentState() );

		player.handleEvent(CdPlayerEvents.POWERSWITCHPRESSED);
		assertEquals(CdPlayerStates.STOP, player.getCurrentState() );
		assertEquals(1, player.checkCD );
		assertEquals(1, player.stopPlaying );
		
		player.handleEvent(CdPlayerEvents.PLAYPRESSED);
		assertEquals(CdPlayerStates.PLAY, player.getCurrentState() );
		assertEquals(1, player.stopPlaying );
		assertEquals(1, player.startPlaying );
		
		player.handleEvent(CdPlayerEvents.STOPPRESSED);
		assertEquals(CdPlayerStates.STOP, player.getCurrentState() );
		assertEquals(2, player.stopPlaying );

		player.handleEvent(CdPlayerEvents.OPENCLOSEPRESSED);
		assertEquals(CdPlayerStates.OPEN, player.getCurrentState() );
		assertEquals(1, player.openTray );
		
		
		
		
	}
	
}
