package oaw4.demo.gmf.statemachine2.recipe;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.openarchitectureware.expression.ExecutionContextImpl;
import org.openarchitectureware.expression.ExpressionFacade;
import org.openarchitectureware.expression.Resource;
import org.openarchitectureware.expression.Variable;
import org.openarchitectureware.recipe.workflow.RecipeCreationComponent;
import org.openarchitectureware.type.MetaModel;

public abstract class AbstractExpressionRecipeCreator extends RecipeCreationComponent {

	private List<String> extensions = new ArrayList<String>();
	private List<String> imports = new ArrayList<String>();
	private List<MetaModel> metamodels = new ArrayList<MetaModel>();
	 
	public void addMetaModel(MetaModel metamodel) {
		this.metamodels.add(metamodel);
	}
	
	public void addExtension(String extension) {
		this.extensions.add(extension);
	}
	
	public void addImport(String imp) {
		this.imports.add(imp);
	}
	

	protected Collection createRecipes(Object model, String project) {
		ExecutionContextImpl ctx = new ExecutionContextImpl();
		for (MetaModel mm : metamodels) {
			ctx.registerMetaModel(mm);
		}
		ctx = (ExecutionContextImpl) ctx.cloneWithVariable(new Variable("this",model));
		ctx = (ExecutionContextImpl) ctx.cloneWithResource(new Resource() {

			public String getFullyQualifiedName() {
				return "recipe-creation";
			}

			public String[] getImportedExtensions() {
				return extensions.toArray(new String[extensions.size()]);
			}

			public String[] getImportedNamespaces() {
				return imports.toArray(new String[imports.size()]);
			}

			public void setFullyQualifiedName(String arg0) {
								
			}});
		ExpressionFacade facade = new ExpressionFacade(ctx);
		
		return internalCreateRecipes(facade,project);
	}

	protected abstract Collection internalCreateRecipes(ExpressionFacade facade, String project);
	

}
