package statemachine2.diagram.edit.parts;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Text;
import statemachine2.diagram.part.Statemachine2VisualIDRegistry;

/**
 * @generated
 */
public class Statemachine2EditPartFactory implements EditPartFactory {

	/**
	 * @generated
	 */
	public static final String EXTERNAL_NODE_LABELS_LAYER = "External Node Labels"; //$NON-NLS-1$

	/**
	 * @generated
	 */
	public EditPart createEditPart(EditPart context, Object model) {
		if (model instanceof View) {
			View view = (View) model;
			int viewVisualID = Statemachine2VisualIDRegistry.getVisualID(view);
			switch (viewVisualID) {
			case StateEditPart.VISUAL_ID:
				return new StateEditPart(view);
			case State_nameEditPart.VISUAL_ID:
				return new State_nameEditPart(view);
			case StartStateEditPart.VISUAL_ID:
				return new StartStateEditPart(view);
			case StopStateEditPart.VISUAL_ID:
				return new StopStateEditPart(view);
			case StopState_nameEditPart.VISUAL_ID:
				return new StopState_nameEditPart(view);
			case CompositeStateEditPart.VISUAL_ID:
				return new CompositeStateEditPart(view);
			case CompositeState_name2EditPart.VISUAL_ID:
				return new CompositeState_name2EditPart(view);
			case ActionEditPart.VISUAL_ID:
				return new ActionEditPart(view);
			case Action_kind_nameEditPart.VISUAL_ID:
				return new Action_kind_nameEditPart(view);
			case State2EditPart.VISUAL_ID:
				return new State2EditPart(view);
			case State_name2EditPart.VISUAL_ID:
				return new State_name2EditPart(view);
			case StartState2EditPart.VISUAL_ID:
				return new StartState2EditPart(view);
			case StopState2EditPart.VISUAL_ID:
				return new StopState2EditPart(view);
			case StopState_name2EditPart.VISUAL_ID:
				return new StopState_name2EditPart(view);
			case CompositeState2EditPart.VISUAL_ID:
				return new CompositeState2EditPart(view);
			case CompositeState_nameEditPart.VISUAL_ID:
				return new CompositeState_nameEditPart(view);
			case Action2EditPart.VISUAL_ID:
				return new Action2EditPart(view);
			case Action_nameEditPart.VISUAL_ID:
				return new Action_nameEditPart(view);
			case State_ActionCompartmentEditPart.VISUAL_ID:
				return new State_ActionCompartmentEditPart(view);
			case CompositeState_ActionCompartmentEditPart.VISUAL_ID:
				return new CompositeState_ActionCompartmentEditPart(view);
			case CompositeState_SubStateCompartmentEditPart.VISUAL_ID:
				return new CompositeState_SubStateCompartmentEditPart(view);
			case State_ActionCompartment2EditPart.VISUAL_ID:
				return new State_ActionCompartment2EditPart(view);
			case CompositeState_ActionCompartment2EditPart.VISUAL_ID:
				return new CompositeState_ActionCompartment2EditPart(view);
			case CompositeState_SubStateCompartment2EditPart.VISUAL_ID:
				return new CompositeState_SubStateCompartment2EditPart(view);
			case StateMachineEditPart.VISUAL_ID:
				return new StateMachineEditPart(view);
			case TransitionEditPart.VISUAL_ID:
				return new TransitionEditPart(view);
			case Transition_name_event_guardEditPart.VISUAL_ID:
				return new Transition_name_event_guardEditPart(view);
			}
		}
		return createUnrecognizedEditPart(context, model);
	}

	/**
	 * @generated
	 */
	private EditPart createUnrecognizedEditPart(EditPart context, Object model) {
		// Handle creation of unrecognized child node EditParts here
		return null;
	}

	/**
	 * @generated
	 */
	public static CellEditorLocator getTextCellEditorLocator(
			ITextAwareEditPart source) {
		if (source.getFigure() instanceof WrapLabel)
			return new TextCellEditorLocator((WrapLabel) source.getFigure());
		else {
			IFigure figure = source.getFigure();
			return new LabelCellEditorLocator((Label) figure);
		}
	}

	/**
	 * @generated
	 */
	static private class TextCellEditorLocator implements CellEditorLocator {

		/**
		 * @generated
		 */
		private WrapLabel wrapLabel;

		/**
		 * @generated
		 */
		public TextCellEditorLocator(WrapLabel wrapLabel) {
			super();
			this.wrapLabel = wrapLabel;
		}

		/**
		 * @generated
		 */
		public WrapLabel getWrapLabel() {
			return wrapLabel;
		}

		/**
		 * @generated
		 */
		public void relocate(CellEditor celleditor) {
			Text text = (Text) celleditor.getControl();
			Rectangle rect = getWrapLabel().getTextBounds().getCopy();
			getWrapLabel().translateToAbsolute(rect);

			if (getWrapLabel().isTextWrapped()
					&& getWrapLabel().getText().length() > 0)
				rect.setSize(new Dimension(text.computeSize(rect.width,
						SWT.DEFAULT)));
			else {
				int avr = FigureUtilities.getFontMetrics(text.getFont())
						.getAverageCharWidth();
				rect.setSize(new Dimension(text.computeSize(SWT.DEFAULT,
						SWT.DEFAULT)).expand(avr * 2, 0));
			}

			if (!rect.equals(new Rectangle(text.getBounds())))
				text.setBounds(rect.x, rect.y, rect.width, rect.height);
		}

	}

	/**
	 * @generated
	 */
	private static class LabelCellEditorLocator implements CellEditorLocator {

		/**
		 * @generated
		 */
		private Label label;

		/**
		 * @generated
		 */
		public LabelCellEditorLocator(Label label) {
			this.label = label;
		}

		/**
		 * @generated
		 */
		public Label getLabel() {
			return label;
		}

		/**
		 * @generated
		 */
		public void relocate(CellEditor celleditor) {
			Text text = (Text) celleditor.getControl();
			Rectangle rect = getLabel().getTextBounds().getCopy();
			getLabel().translateToAbsolute(rect);

			int avr = FigureUtilities.getFontMetrics(text.getFont())
					.getAverageCharWidth();
			rect.setSize(new Dimension(text.computeSize(SWT.DEFAULT,
					SWT.DEFAULT)).expand(avr * 2, 0));

			if (!rect.equals(new Rectangle(text.getBounds())))
				text.setBounds(rect.x, rect.y, rect.width, rect.height);
		}
	}
}
