package org.openarchitectureware.adapter.gmf.constraint;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.openarchitectureware.check.CheckFacade;
import org.openarchitectureware.expression.ExecutionContext;
import org.openarchitectureware.expression.ExecutionContextImpl;
import org.openarchitectureware.type.emf.EmfMetaModel;
import org.openarchitectureware.workflow.issues.Issue;
import org.openarchitectureware.workflow.issues.Issues;
import org.openarchitectureware.workflow.issues.IssuesImpl;
import org.openarchitectureware.workflow.util.ResourceLoaderFactory;
import org.openarchitectureware.workflow.util.ResourceLoaderImpl;


public abstract class AbstractOAWConstraints extends AbstractModelConstraint {

    public AbstractOAWConstraints() {
        super();
    }

    protected abstract String getCheckFileName();
    
    public IStatus validate(IValidationContext ctx) {
        Object target = ctx.getTarget();
        Issues issues = new IssuesImpl();
        ResourceLoaderFactory.setCurrentThreadResourceLoader(new ResourceLoaderImpl(getClass().getClassLoader()));
        CheckFacade.checkAll( getCheckFileName(), Collections.singleton(target),
                getExecutionContext(), issues);
        if (issues.hasErrors()) {
            StringBuffer msg = new StringBuffer();
            for (int i = 0; i < issues.getErrors().length; i++) {
                Issue is = issues.getErrors()[i];
                msg.append(is.getMessage());
            }
            return ctx.createFailureStatus(new Object[] { msg.toString() });
        }
        return ctx.createSuccessStatus();
    }

    private ExecutionContextImpl ctx = null;

    private ExecutionContext getExecutionContext() {
        if (ctx == null) {
            ctx = new ExecutionContextImpl();
            List l = getMetamodelPackages();
            for (Iterator iter = l.iterator(); iter.hasNext();) {
				EPackage pkg = (EPackage) iter.next();
	            ctx.registerMetaModel(new EmfMetaModel(pkg));
			}
        }
        return ctx;
    }
    
    protected abstract List getMetamodelPackages();

    protected List makeList(Object o) {
    	List l = new ArrayList();
    	l.add(o);
    	return l;
    }
    
    protected List makeList(Object o1, Object o2) {
    	List l = makeList(o1);
    	l.add(o2);
    	return l;
    }
    
    protected List makeList(Object o1, Object o2, Object o3) {
    	List l = makeList(o1, o2);
    	l.add(o3);
    	return l;
    }
    
}
