using System;
using System.Collections.Generic;
using System.Text;

namespace de.WWWings
{

 /// <summary>
 /// Hndische Implementierung des Objek-Relationalen Mappings fr die Tabele FL_Fluege auf die Klassen Flug und FlugMenge.<remarks>
 /// In World Wide Wings wird bewut keins der am Markt verfgbaren Drittanbieterwerkzeuge fr ORM eingesetzt, da erstens die Komplexitt des Beispiels nicht weiter erhht werden soll und zweitens eine Marktbereinigung zu erwarten ist, sobald Microsoft die angekndigten ORM-Werkzeuge auf den Markt bringt.</remarks>
 /// </summary>
 class ORM_Flug
 {

  #region Mapping
  /// <summary>
  /// Mapping fr DataRow "zu Fu programmiert!"
  /// </summary>
  public static Flug MapRow(System.Data.DataRow dr)
  {
   Flug f = new Flug();
   f.FlugNr = Convert.ToInt64(dr["fl_flugnr"]);
   f.AbflugOrt = dr["fl_AbflugOrt"].ToString() ?? "n/a";
   f.ZielOrt = dr["fl_ZielOrt"].ToString() ?? "n/a";
   f.Plaetze = Convert.ToInt64(dr["fl_Plaetze"]);
   f.FreiePlaetze = Convert.ToInt64(dr["fl_FreiePlaetze"]);
   f.Datum = Convert.ToDateTime(dr["Fl_Datum"]);
   return f;
  }

  /// <summary>
  /// Mapping fr DataRreader
  /// </summary>
  public static Flug MapRow(System.Data.IDataReader dr)
  {
   Flug f = new Flug();
   f.FlugNr = Convert.ToInt64(dr["fl_flugnr"]);
   f.AbflugOrt = dr["fl_AbflugOrt"].ToString();
   f.ZielOrt = dr["fl_ZielOrt"].ToString() ?? "n/a";
   f.Plaetze = Convert.ToInt64(dr["fl_Plaetze"]);
   f.FreiePlaetze = Convert.ToInt64(dr["fl_FreiePlaetze"]);
   f.Datum = Convert.ToDateTime(dr["Fl_Datum"]);
   return f;
  }

  /// <summary>
  /// Mapping fr DataTable
  /// </summary>
  /// <param name="dt">DataTable-Objekt</param>
  /// <returns>Menge von Flugobjekten</returns>
  public static FlugMenge MapTable(System.Data.DataTable dt)
  {
   FlugMenge ff = new FlugMenge();
   foreach (System.Data.DataRow dr in dt.Rows)
   {
    Flug f = MapRow(dr);
    ff.Add(f);
   }
   return ff;
  }
  #endregion
 }
}
