﻿#region Using directives

using System;
using System.Collections.Generic;
using System.Text;

#endregion

namespace de.WWWings.PassagierSystem
{
 /// <summary>
 /// Spezieller Anwendungsfehler: Ungültige Flugnummer wurde verwendet
 /// </summary>
 public class FalscheFlugnummer : System.ApplicationException
 {
  public FalscheFlugnummer(string Beschreibung) : base(Beschreibung)  { }
 }

 /// <summary>
 /// Spezieller Anwendungsfehler: Passagier will in einem Flug einchecken, auf dem er nicht gebucht ist
 /// </summary>
 public class PassagierNichtAufFlugGebucht : FalscheFlugnummer
 {
  public PassagierNichtAufFlugGebucht(string Beschreibung) : base(Beschreibung) { }
 }
}
