using System;
using System.Collections.Generic;
using System.Text;
using System.Workflow.Runtime;
using System.Workflow.Activities;

namespace de.WWWings.Workflow
{



 [ExternalDataExchange]
 public interface IBuchungsdienst
 {
  event EventHandler<PersonenDaten> PersonenDaten_Bereit;
  event EventHandler<FlugDaten> FlugDaten_Bereit;
  event EventHandler<ZahlungsDaten> ZahlungsDaten_Bereit;
  void Status(string Statustext);
 }

 /// <summary>
 /// WF-Datenaustauschdienst fr WWWings-Flugbuchung
 /// </summary>
 public class Buchungsdienst : de.WWWings.Workflow.IBuchungsdienst
 {

  //public event EventHandler<string> WorkflowMeldetNeuenStatus;

  public void Status(string Statustext)
  {

   //if (!WorkflowMeldetNeuenStatus != 0) WorkflowMeldetNeuenStatus(null, StatusText);

  }

  /// <summary>
  /// Signalisierung von Daten gegenber dem Workflow
  /// </summary>
  public event EventHandler<PersonenDaten> PersonenDaten_Bereit;
  /// <summary>
  /// Signalisierung von Daten gegenber dem Workflow
  /// </summary>
  public event EventHandler<FlugDaten> FlugDaten_Bereit;
  /// <summary>
  /// Signalisierung von Daten gegenber dem Workflow
  /// </summary>
  public event EventHandler<ZahlungsDaten> ZahlungsDaten_Bereit;


  /// <summary>
  /// Startet Datensendung an den Worklow
  /// </summary>
  public bool SendePersonenDaten(Guid Instanz, string Name, string EMail)
  {
   de.WWWings.Workflow.PersonenDaten p = new de.WWWings.Workflow.PersonenDaten(Instanz);
   p.Name = Name;
   p.EMail = EMail;

   try
   {
    if (this.PersonenDaten_Bereit != null) this.PersonenDaten_Bereit(null, p);
   }
   catch
   {
    return false;
   }
   return true;
  }

  /// <summary>
  /// Startet Datensendung an den Worklow
  /// </summary>
  public bool SendeFlugDaten(Guid Instanz, long FlugNr)
  {
   de.WWWings.Workflow.FlugDaten p = new de.WWWings.Workflow.FlugDaten(Instanz);
   p.FlugNr = FlugNr;
   if (this.FlugDaten_Bereit != null) this.FlugDaten_Bereit(null, p);
   return true;
  }

  /// <summary>
  /// Startet Datensendung an den Worklow
  /// </summary>
  public bool SendeZahlngsDaten(Guid Instanz, string Kartentyp, long KartenNummer, DateTime datum)
  {
   de.WWWings.Workflow.ZahlungsDaten p = new de.WWWings.Workflow.ZahlungsDaten(Instanz);
   p.Kartenart = Kartenarten.Visa;
   p.KreditkartenNummer = KartenNummer;
   p.GueltigBis = datum;
   if (this.ZahlungsDaten_Bereit != null) this.ZahlungsDaten_Bereit(null, p);
   return true;
  }


 }
}
