#region Using directives

using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Workflow.Runtime;
using System.Workflow.Runtime.Hosting;
using System.Workflow.Activities;
using System.Collections.Specialized;

#endregion

namespace WWW_WorkflowHost
{
 class Program
 {

  public static WorkflowRuntime WorkflowRuntime = new WorkflowRuntime();
  public static ExternalDataExchangeService WFDatenDienst;
  public static SqlWorkflowPersistenceService WFPersistenzDienst;
  public static System.Workflow.Runtime.Tracking.SqlTrackingService WFTrackingDienst;
  const string ConnectionString = @"Initial Catalog=WWWings_Workflow;Data Source=.\sqlexpress;Integrated Security=SSPI;";

  /// <summary>
  /// Hauptprogramm fr den Workflow-Server
  /// </summary>
  static void Main(string[] args)
  {

   // Datendienst
   WFDatenDienst = new ExternalDataExchangeService();
   Program.WorkflowRuntime.AddService(WFDatenDienst);

   // Persistenzdienst
   NameValueCollection Parameter = new NameValueCollection();
   Parameter.Add("UnloadOnIdle", "true");
   Parameter.Add("ConnectionString", ConnectionString);
   WFPersistenzDienst = new SqlWorkflowPersistenceService(Parameter);
   Program.WorkflowRuntime.AddService(WFPersistenzDienst);

   // Ablaufverfolgung
   WFTrackingDienst = new System.Workflow.Runtime.Tracking.SqlTrackingService(ConnectionString);
   Program.WorkflowRuntime.AddService(WFTrackingDienst);

   // Starten der WF-Laufzeitumgebung
   Program.WorkflowRuntime.StartRuntime();

   // Anzeige des GUIs
   System.Windows.Forms.Application.Run(new F_FlugBuchung());
  }



 }
}
