﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using de.WWWings;
using de.ITVisions.DALUtil;
using System.EnterpriseServices;
using System.Runtime.CompilerServices;

namespace de.WWWings.DAL
{
 /// <summary>
 /// Datenzugriffsmanager für die Tabelle Fluege
 /// Verwendet Transaktionen in Enterprise Services
 /// </summary>
 /// 
 //[Description("Flugmanager für WorldWideWings")]
 //[System.EnterpriseServices.Synchronization(SynchronizationOption.Required)]
 //[Transaction(TransactionOption.Disabled)]
 //[ObjectPoolingAttribute(true, 10, 20)]
 //[EventTrackingEnabled(true)]
 //[System.Runtime.InteropServices.Guid("9C74BA6A-9D1C-4fe7-808E-04E6665D0251")]
 public class Flug_DataManager // : ServicedComponent
 {

  /// <summary>
  /// Festlegen der Datenbank beim Starten der Klasse
  /// </summary>
  public Flug_DataManager()
  {
   DBUtil.SetDatabase(DBUtil.Providers.MSSQL, DBConfig.CONN_MSSQL);
  }
  // ---------------------------------------------------
  #region Datensätze zählen
  /// <summary>
  /// Anzahl der Datensätze ermitteln
  /// </summary>
  /// <returns></returns>
  public static int Count()
  {
   return (int)(DBUtil.Count("Select count(*) from FL_Fluege"));
  }

  /// <summary>
  /// Anzahl der Datensätze ermitteln für einen Abflugort
  /// </summary>
  /// <returns></returns>
  public static int Count(string Abflugort)
  {
   return (int)(DBUtil.Count("Select count(*) from FL_Fluege where FL_Abflugort='" + Abflugort + "'"));
  }
  #endregion
  // ---------------------------------------------------
  #region Daten lesen ohne Filtern
  /// <summary>
  /// Alle Flüge auf einer bestimmten Route
  /// </summary>
  /// <param name="Abflughafen"></param>
  /// <param name="FL_Zielflughafen"></param>
  /// <returns></returns>
  public static DataSet AlleFluegeRoute(string Abflughafen, string FL_Zielflughafen)
  {
   string SQL = "Select * from FL_Fluege where Fl_Abflugort = '" + Abflughafen + "' and FL_zielort = '" + FL_Zielflughafen + "'";
   return DBUtil.GetDataSet(SQL);
  }

  /// <summary>
  /// Diese Methode liefert eine Liste aller  Abflughäfen in Form eines String-Array
  /// </summary>
  /// <returns>String-Array mit Abflugorten</returns>
  public static string[] AlleAbflughaefen()
  {
   const string SQL = "Select FL_Abflugort from FL_Fluege group by FL_Abflugort";
   return DBUtil.GetColumn(SQL);
  }

  public static DataSet AlleAbflughaefen_DS()
  {
   const string SQL = "Select Fl_Abflugort from FL_Fluege group by Fl_Abflugort";
   return DBUtil.GetDataSet(SQL);
  }



  /// <summary>
  /// Liste aller Flüge
  /// </summary>
  /// <returns>Dataset</returns>
  public static DataSet AlleFluege_DS()
  {
   const string SQL = "Select * from FL_Fluege";
   return DBUtil.GetDataSet(SQL);
  }

  /// <summary>
  /// Liste aller Flüge (mit Paging)
  /// </summary>
  /// <param name="von"></param>
  /// <param name="Anzahl"></param>
  /// <returns></returns>
  public static DataSet AlleFluege_DS(long von, long Anzahl)
  {
   long Erster = von + 1;
   long Letzter = von + 1 + Anzahl - 1;
   string SQL = "With ordered as (Select Row_Number() Over (order by FL_FlugNr) as RowNumber, * from FL_Fluege) Select * from ordered where RowNumber between " + Erster + " and " + Letzter;
   return DBUtil.GetDataSet(SQL);
  }

  /// <summary>
  /// Liste aller Flüge (mit Paging und Sortieren)
  /// </summary>
  /// <param name="sort"></param>
  /// <param name="von"></param>
  /// <param name="bis"></param>
  /// <returns>Datatable</returns>
  public static DataTable AlleFluege_DT(string sort, long von, long bis)
  {
   return AlleFluege_DS(sort, von, bis).Tables[0];
  }

  /// <summary>
  /// Liste aller Flüge (mit Paging und Sortieren)
  /// </summary>
  /// <param name="sort"></param>
  /// <param name="von"></param>
  /// <param name="bis"></param>
  /// <returns>Dataset</returns>
  public static DataSet AlleFluege_DS(string sort, long von, long bis)
  {
   if (sort == "") return AlleFluege_DS(von, bis);
   string SQL = "With ordered as (Select Row_Number() Over (order by FL_FlugNr) as RowNumber, * from FL_Fluege order by " + sort + ") Select * from ordered where RowNumber between " + von + " and " + bis;
   return DBUtil.GetDataSet(SQL);
  }
  #endregion
  // ---------------------------------------------------
  #region Daten lesen mit Filtern
  /// <summary>
  /// Liste aller Flüge von einem Abflugort
  /// </summary>
  /// <param name="Fl_Abflugort"></param>
  /// <returns></returns>
  public static DataSet AlleFluege_DS(string Fl_Abflugort)
  {
   if (Fl_Abflugort == "*")
    return AlleFluege_DS();
   string SQL = "Select * from FL_Fluege where Fl_Abflugort = '" + Fl_Abflugort + "'";
   return DBUtil.GetDataSet(SQL);
  }

  public static DataSet AlleFluege_DS_Sort(string Fl_Abflugort, string sortierung)
  {
   if (Fl_Abflugort == "*")
    return AlleFluege_DS();
   string SQL = "Select * from FL_Fluege where Fl_Abflugort = '" + Fl_Abflugort + "' order by " + sortierung;
   return DBUtil.GetDataSet(SQL);
  }


  /// <summary>
  /// Liste aller Flüge zu einem Zielort
  /// </summary>
  /// <param name="Fl_Abflugort"></param>
  /// <returns></returns>
  public static DataSet AlleFluege_Zielort(string fl_Zielort)
  {
   if (fl_Zielort == "*")
    return AlleFluege_DS();
   string SQL = "Select * from FL_Fluege where Fl_Zielort='" + fl_Zielort + "'";
   return DBUtil.GetDataSet(SQL);
  }

  /// <summary>
  /// Alle Flüge auf einer bestimmten Route
  /// </summary>
  /// <param name="Fl_Abflugort"></param>
  /// <returns></returns>
  public static DataSet AlleFluege_Strecke(string Fl_Abflugort, string fl_Zielort)
  {
   if (Fl_Abflugort == "*")
    return AlleFluege_Zielort(fl_Zielort);
   if (fl_Zielort == "*")
    return AlleFluege_DS(Fl_Abflugort);
   string SQL = "Select * from FL_Fluege where Fl_Abflugort = '" + Fl_Abflugort + "' and Fl_Zielort='" + fl_Zielort + "'";
   return DBUtil.GetDataSet(SQL);
  }

  /// <summary>
  /// Liste aller Flüge von einem Abflugort (mit Paging und Sortieren)
  /// </summary>
  /// <param name="Abflugort"></param>
  /// <param name="sort"></param>
  /// <param name="von"></param>
  /// <param name="bis"></param>
  /// <returns></returns>
  public static DataSet AlleFluege_DS(string Abflugort, string sort, long von, long bis)
  {
   if (sort == "") return AlleFluegeNachOrt_DS(Abflugort, von, bis);
   string SQL = "With ordered as (Select Row_Number() Over (order by FL_FlugNr) as RowNumber, * from FL_Fluege where Fl_Abflugort='" + Abflugort + "' ) Select * from ordered where RowNumber between " + von + " and " + bis + " order by " + sort;
   return DBUtil.GetDataSet(SQL);
  }

  /// <summary>
  /// Liste aller Flüge von einem Abflugort (mit Paging)
  /// </summary>
  /// <param name="Abflugort"></param>
  /// <param name="von"></param>
  /// <param name="Anzahl"></param>
  /// <returns></returns>
  public static DataSet AlleFluegeNachOrt_DS(string Abflugort, long von, long Anzahl)
  {
   long bis = von + Anzahl;
   string SQL = "With ordered as (Select Row_Number() Over (order by FL_FlugNr) as RowNumber, * from FL_Fluege where Fl_Abflugort='" + Abflugort + "' ) Select * from ordered where RowNumber between " + von + " and " + bis;
   return DBUtil.GetDataSet(SQL);
  }
  #endregion
  // ---------------------------------------------------
  #region Datensätze verändern
  /// <summary>
  /// Zurückschreiben eines Dataset Diffgrams
  /// </summary>
  /// <param name="ds"></param>
  public static void Update(DataSet ds)
  {
   DBUtil.UpdateDS(ds, "Select * from FL_fluege");
  }

  /// <summary>
  /// Zurückschreiben eines einzelnen Flug-Datensatz
  /// </summary>
  /// <param name="FL_Abflugort"></param>
  /// <param name="FL_ZielOrt"></param>
  /// <param name="FL_Plaetze"></param>
  /// <param name="original_Fl_FlugNr"></param>
  public static void Update(string FL_Abflugort, string FL_ZielOrt, long FL_Plaetze, long original_Fl_FlugNr)
  {
   DBUtil.Execute("UPDATE Fl_Fluege SET FL_Abflugort = '" + FL_Abflugort + "', FL_ZielOrt = '" + FL_ZielOrt + "', FL_Plaetze = " + FL_Plaetze + " WHERE Fl_FlugNr = " + original_Fl_FlugNr);
   return;
  }

  /// <summary>
  /// Zurückschreiben eines einzelnen Flug-Datensatz
  /// </summary>
  /// <param name="FL_Abflugort"></param>
  /// <param name="FL_ZielOrt"></param>
  /// <param name="FL_Plaetze"></param>
  /// <param name="FL_NichtRaucherFlug"></param>
  /// <param name="FL_EingerichtetAm"></param>
  /// <param name="original_Fl_FlugNr"></param>
  public static void Update(string FL_Abflugort, string FL_ZielOrt, long FL_Plaetze, bool FL_NichtRaucherFlug, DateTime FL_EingerichtetAm, int original_Fl_FlugNr)
  {
   DBUtil.Execute("UPDATE Fl_Fluege SET FL_Abflugort = '" + FL_Abflugort + "', FL_ZielOrt = '" + FL_ZielOrt + "', FL_Plaetze = " + FL_Plaetze + " WHERE Fl_FlugNr = " + original_Fl_FlugNr);

  }

  /// <summary>
  /// Zurückschreiben eines einzelnen Flug-Datensatz
  /// </summary>
  /// <param name="FL_Abflugort"></param>
  /// <param name="FL_ZielOrt"></param>
  /// <param name="FL_Datum"></param>
  /// <param name="FL_NichtRaucherFlug"></param>
  /// <param name="FL_Plaetze"></param>
  /// <param name="FL_FreiePlaetze"></param>
  /// <param name="FL_PI_MI_MitarbeiterNr"></param>
  /// <param name="FL_AnzahlStarts"></param>
  /// <param name="FL_EingerichtetAm"></param>
  /// <param name="Fl_FlugNr"></param>
  public static void Update(string FL_Abflugort, string FL_ZielOrt, DateTime FL_Datum, bool FL_NichtRaucherFlug, long FL_Plaetze, int FL_FreiePlaetze, long FL_PI_MI_MitarbeiterNr, long FL_AnzahlStarts, DateTime FL_EingerichtetAm, int Fl_FlugNr)
  {
   DBUtil.Execute("UPDATE Fl_Fluege SET FL_Abflugort = '" + FL_Abflugort + "', FL_ZielOrt = '" + FL_ZielOrt + "', FL_Plaetze = " + FL_Plaetze + " WHERE Fl_FlugNr = " + Fl_FlugNr);

  }

  /// <summary>
  /// Hinzufügen eines Flugs
  /// </summary>
  /// <param name="FL_Abflugort"></param>
  /// <param name="FL_ZielOrt"></param>
  /// <param name="FL_NichtRaucherFlug"></param>
  /// <param name="FL_Plaetze"></param>
  /// <param name="FL_EingerichtetAm"></param>
  /// <param name="FL_FlugNr"></param>
  public static void Insert(string FL_Abflugort, string FL_ZielOrt, bool FL_NichtRaucherFlug, long FL_Plaetze, DateTime FL_EingerichtetAm, int FL_FlugNr)
  {
   DBUtil.Execute("Insert into Fl_Fluege (Fl_Flugnr, FL_Abflugort, Fl_Zielort, Fl_Plaetze, Fl_NichtraucherFlug) Values (" + FL_FlugNr + ",'" + FL_Abflugort + "', '" + FL_ZielOrt + "', " + FL_Plaetze + ", '" + FL_NichtRaucherFlug + "')");
  }

  /// <summary>
  /// Hinzufügen eines Flugs
  /// </summary>
  /// <param name="FL_Abflugort"></param>
  /// <param name="FL_ZielOrt"></param>
  /// <param name="FL_NichtRaucherFlug"></param>
  /// <param name="FL_Plaetze"></param>
  /// <param name="FL_FreiePlaetze"></param>
  /// <param name="FL_Datum"></param>
  /// <param name="FL_EingerichtetAm"></param>
  /// <param name="FL_FlugNr"></param>
  public static void Insert(string FL_Abflugort, string FL_ZielOrt, bool FL_NichtRaucherFlug, long FL_Plaetze, long FL_FreiePlaetze, DateTime FL_Datum, DateTime FL_EingerichtetAm, int FL_FlugNr)
  {
   DBUtil.Execute("Insert into Fl_Fluege (Fl_Flugnr, FL_Abflugort, Fl_Zielort, FL_Datum, Fl_Plaetze, Fl_FreiePlaetze,Fl_NichtraucherFlug) Values (" + FL_FlugNr + ",'" + FL_Abflugort + "', '" + FL_ZielOrt + "', '" + FL_Datum.ToString(new System.Globalization.CultureInfo("en-us")) + "'," + FL_Plaetze + ", " + FL_FreiePlaetze + ",'" + FL_NichtRaucherFlug + "')");

  }

  /// <summary>
  /// Hinzufügen eines Flugs
  /// </summary>
  /// <param name="FL_Abflugort"></param>
  /// <param name="FL_Zielort"></param>
  /// <param name="FL_Datum"></param>
  /// <param name="FL_NichtRaucherFlug"></param>
  /// <param name="FL_Plaetze"></param>
  /// <param name="FL_FreiePlaetze"></param>
  /// <param name="FL_PI_MI_MitarbeiterNr"></param>
  /// <param name="FL_AnzahlStarts"></param>
  /// <param name="FL_EingerichtetAm"></param>
  /// <param name="Fl_FlugNr"></param>
  public static void Insert(string FL_Abflugort, string FL_Zielort, DateTime FL_Datum, bool FL_NichtRaucherFlug, long FL_Plaetze, long FL_FreiePlaetze, long FL_PI_MI_MitarbeiterNr, long FL_AnzahlStarts, DateTime FL_EingerichtetAm, int Fl_FlugNr)
  {
   DBUtil.Execute("Insert into Fl_Fluege (Fl_Flugnr, FL_Abflugort, Fl_Zielort, FL_Datum, Fl_Plaetze, Fl_FreiePlaetze,Fl_NichtraucherFlug) Values (" + Fl_FlugNr + ",'" + FL_Abflugort + "', '" + FL_Zielort + "', '" + FL_Datum.ToString(new System.Globalization.CultureInfo("en-us")) + "'," + FL_Plaetze + ", " + FL_FreiePlaetze + ",'" + FL_NichtRaucherFlug + "')");
  }

  /// <summary>
  /// Löschen eines Flugs
  /// </summary>
  /// <param name="Original_Fl_FlugNr"></param>
  public static void LoescheFlug(int Original_Fl_FlugNr)
  {
   DBUtil.Execute("Delete from Fl_Fluege where Fl_FlugNr = " + Original_Fl_FlugNr + "");
  }
  #endregion
  // ---------------------------------------------------
  #region Überwachen auf Veränderungen
  public delegate void FluegeWurdenAktualisiertHandler();
  public event FluegeWurdenAktualisiertHandler FluegeWurdenAktualisiert;
  System.Data.SqlClient.SqlDependency dep;

  /// <summary>
  /// Initalisierung der Benachrichtung über Datenänderungen
  /// </summary>
  /// <param name="Zielort"></param>
  public void AktualisierungenMelden(string Zielort)
  {
   dep = SQLUtil.DeclareQueryNotfication("Select FL_FlugNr,Fl_Abflugort, FL_Zielort, Fl_Plaetze, Fl_FreiePlaetze from dbo.FL_Fluege where FL_zielort = '" + Zielort + "'");

   dep.OnChange += new OnChangeEventHandler(dep_OnChange);


  }

  /// <summary>
  /// Reaktion auf Datenänderungen
  /// </summary>
  /// <param name="sender"></param>
  /// <param name="e"></param>
  void dep_OnChange(object sender, SqlNotificationEventArgs e)
  {
   if (e.Type == SqlNotificationType.Subscribe)
   {
    throw new Exception("Fehler in Query Notification: " + e.Info.ToString());
   }
   else
   {
    if (FluegeWurdenAktualisiert != null) FluegeWurdenAktualisiert();
   }
  }

  #endregion
  // ---------------------------------------------------
  #region Einsatz von Datareadern zum Datenlesen (Alternative Implementierung)

  /// <summary>
  /// Flüge lesen mit einem DataReader
  /// </summary>
  /// <returns>Geöffneter DataReader</returns>
  public DbDataReader AlleFluege_DR()
  {
   const string SQL = "Select * from FL_Fluege";
   return DBUtil.GetReader(SQL);
  }

  /// <summary>
  /// Flüge lesen mit einem DataReader (Gefiltert)
  /// </summary>
  /// <returns>Geöffneter DataReader</returns>
  public DbDataReader AlleFluegeFuerAbflughafen_DR(string Abflughafen)
  {
   string SQL = "Select * from FL_Fluege where Fl_Abflugort = '" + Abflughafen + "'";
   return DBUtil.GetReader(SQL);
  }



  /// <summary>
  /// Einen Flug holen anhand seiner Flugnummer
  /// </summary>
  /// <returns>DataRow</returns>
  public DataRow GetFlug(long FlugNr)
  {
   string SQL = "Select * from FL_Fluege where fl_flugnr = " + FlugNr + "";
   return DBUtil.GetDataRow(SQL);
  }

  /// <summary>
  /// Einen Flug holen anhand seiner Flugnummer
  /// </summary>
  /// <returns>Geöffneter DataReader</returns>
  public DbDataReader GetFlug_DR(long FlugNr)
  {
   string SQL = "Select * from FL_Fluege where fl_flugnr = " + FlugNr + "";
   DbDataReader dr = DBUtil.GetReader(SQL);
   dr.Read();
   return dr;
  }
  #endregion

 }
}
