using System;
using System.Collections.Generic;
using System.Text;
using de.WWWings.PassagierSystem;

namespace de.WWWings.ORM
{

 /// <summary>
 /// Hndische Implementierung des Objek-Relationalen Mappings fr die Sicht AllePassagiere auf die Klassen Passagier und PassagierMenge.<remarks>
 /// In World Wide Wings wird bewut keins der am Markt verfgbaren Drittanbieterwerkzeuge fr ORM eingesetzt, da erstens die Komplexitt des Beispiels nicht weiter erhht werden soll und zweitens eine Marktbereinigung zu erwarten ist, sobald Microsoft die angekndigten ORM-Werkzeuge auf den Markt bringt.</remarks>
 /// </summary>
 class ORM_Passagier
 {

  /// <summary>
  /// Mapping fr DataRow "zu Fu programmiert!"
  /// </summary>
  public static Passagier MapRow(System.Data.DataRow dr)
  {
   Passagier p = new Passagier();
   p.Nachname = dr["PE_Name"].ToString();
   p.Vorname = dr["PE_Vorname"].ToString();
   p.PID = Convert.ToInt64(dr["PS_ID"]);
   p.PersonalausweisNr = (dr["PS_PE_Personalausweisnummer"]).ToString();
   return p;
  }

 
  /// <summary>
  /// Mapping fr DataTable
  /// </summary>
  /// <param name="dt">DataTable-Objekt</param>
  /// <returns>Menge von Passagier-Objekten</returns>
  public static de.WWWings.PassagierSystem.PassagierMenge MapTable(System.Data.DataTable dt)
  {
   PassagierMenge pp = new PassagierMenge();
   foreach (System.Data.DataRow dr in dt.Rows)
   {
    Passagier p = MapRow(dr);
    pp.Add(p);
   }
   return pp;
  }
 }
}
