﻿using System;
using System.Collections.Generic;
using System.Text;

namespace de.WWWings.PassagierSystem
{

 /// <summary>
 /// Daten einer Flugbuchung
 /// </summary>
 /// 
 [System.Serializable()]
 public class Buchung
 {
  private long buchungscode = 0;

  public long Buchungscode
  {
   get { return buchungscode; }
   set { buchungscode = value; }
  }
  private string klasse = "M";

  public string Klasse
  {
   get { return klasse; }
   set { klasse = value; }
  }
  public FlugMenge Fluege = new FlugMenge();
  public Passagier Passagier = null;


  public string Abflugort
  {
   get { return Fluege[0].AbflugOrt; }
  }

  public string Zielort
  {
   get { return Fluege[Fluege.Count - 1].ZielOrt; }
  }

  public DateTime Datum
  {
   get { return Fluege[0].Datum; }
  }

  public long FlugNr
  {
   get { return Fluege[0].FlugNr; }
  }

  public int Teilstrecken
  {
   get { return Fluege.Count; }
  }


  public string DetailInfo
  {
   get { 
    return  String.Format("Gebucht ist der Flug {0} am {1} von {2} nach {3} über {4} Teilstrecken mit Buchungscode {5}!", this.FlugNr, this.Datum,this.Abflugort,this.Zielort, this.Buchungscode);   
   }

  }
	



  /// <summary>
  /// Neue Buchung über Nummern
  /// </summary>
  public Buchung(long FlugNr, long PassagierNummer)
  {
   Fluege.Add(de.WWWings.FlugBLManager.HoleFlug(FlugNr));
   Passagier = de.WWWings.Passagier_BLManager.HolePassagier(PassagierNummer);
   GeneriereBuchungscode(FlugNr, PassagierNummer);
  }

  /// <summary>
  /// Bei Flügen mit mehreren Teilstrecken verwende zur Generierung des Buchungscodes die Nummer des ersten Flugs
  /// </summary>
  public Buchung(long[] FlugNr, long PassagierNummer)
   : this(FlugNr[0], PassagierNummer)
  {
  }


  /// <summary>
  /// Neue Buchung unter Angabe der Objekte
  /// </summary>
  public Buchung(Flug Flug, Passagier Passagier)
  {
   this.Fluege.Add(Flug);
   this.Passagier = Passagier;
   GeneriereBuchungscode(Flug.FlugNr, Passagier.PID);
  }

  /// <summary>
  /// Erzeugung des Buchungscodes aus Flugnummer, Passagiernummer und einer Zufallszahl
  /// </summary>
  private void GeneriereBuchungscode(long FlugNr, long PassagierNummer)
  {
   long Nummer = new Random().Next(999);
   this.Buchungscode = Convert.ToInt64(FlugNr.ToString("000") + PassagierNummer.ToString("0000")); // + Nummer.ToString("000"));
  }
 }
}
