﻿#region Using directives

using System;
using System.Collections.Generic;
using System.Text;

#endregion
using de.WWWings;

namespace de.WWWings
{
 [Serializable()]
 public partial class Flug
 {
  public Flug()
  { }

  #region Konstruktoren
  // ========== Konstruktor 1
  public Flug(long FlugNr, string AbflugOrt, string ZielOrt)
  {
   this.FlugNr = FlugNr;
   this.AbflugOrt = AbflugOrt;
   this.ZielOrt = ZielOrt;
   if (Flug.Fluege.ContainsKey(this.FlugNr)) Flug.Fluege.Remove(this.FlugNr);
   Flug.Fluege.Add(this.FlugNr, this);
   Console.WriteLine("Flug-Objekt wurde instanziiert: " + this.FlugNr);
  }
  // ========== Konstruktor 2
  public Flug(long FlugNr, string AbflugOrt, string ZielOrt, DateTime Datum)
   : this(FlugNr, AbflugOrt, ZielOrt)
  {
   this.Datum = Datum;
  }
  #endregion

  /// <summary>
  /// Operatorüberladung für die Buchung eines Flugs durch Addition eines Flug- und eines Passagier-Objekts.
  /// </summary>
  /// <param name="flug">Flugobjekt</param>
  /// <param name="pass">Passagierobjekt</param>
  /// <returns>Flugobjekt mit hinzugefügten Passagier</returns>
  public static Flug operator +(Flug flug, de.WWWings.PassagierSystem.Passagier pass)
  {
   pass.Buchen(flug);
   return flug;
  }



  public override string ToString()
  {
   return "von " + this.AbflugOrt + " nach " + this.ZielOrt;
  }


  public void Save()
  {
   if (this.Status == ObjektStatus.alt) // Speichern bestehender Flüge
   {
   de.WWWings.FlugBLManager.SpeichereFlug(this);
   }
   else // Speichern neuer Flüge
   {
    // noch nicht implementiert
   }
  }
 }
}


