﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using System.Data.Common;

namespace de.ITVisions.DALUtil
{
 /// <summary>
 /// Dies ist ein Beispiel für eine Implementierung einer Hilfsbibliothek zur Nutzung 
 /// von ADO.NET, aus der Sicht des Nutzers viele Funktionen von ADO.NET auf eine 
 /// Codezeile reduziert.<br/>
 /// Alternative 1: Providerspezifische Implementierung mit System.Data.SqlClient
 /// <remarks>Die einzelnen Methoden haben sprechende Namen und sind daher nicht mit Kommentaren versehen!</remarks>
 /// </summary>
 public class SQLUtil
 {

  /// <summary>
  /// Hole Daten in einem DataReader
  /// </summary>
  /// <param name="SQL"></param>
  /// <returns></returns>
  public static SqlDataReader GetReader(string SQL)
  {
   // Verbindung aufbauen
   SqlConnection sqlConn = new SqlConnection(DBConfig.CONN_MSSQL);
   sqlConn.Open();
   // Befehl ausführen
   SqlCommand sqlCmd = sqlConn.CreateCommand();
   sqlCmd.CommandText = SQL;
   // Datenreader erzeugen
   SqlDataReader dr = sqlCmd.ExecuteReader();
   return dr;
  }


  /// <summary>
  /// Hole Daten in einer DataTable
  /// </summary>
  /// <param name="SQL"></param>
  /// <returns></returns>
  public static DataTable GetDataTable(string SQL)
  {
   return GetDataSet(SQL).Tables[0];
  }

 /// <summary>
 /// Hole eine einzelne DataRow
 /// </summary>
 /// <param name="SQL"></param>
 /// <returns></returns>
  public static string[] GetColumn(string SQL)
  {
   DataTable dt = GetDataSet(SQL).Tables[0];
   string[] Werte = new string[dt.Rows.Count];
   for (int c = 0; c < dt.Rows.Count; c++)
   {
    Werte[c] = dt.Rows[c].ItemArray[0].ToString();
   }
   return Werte;
  }

  /// <summary>
  /// Hole ein Dataset
  /// </summary>
  /// <param name="SQL"></param>
  /// <returns></returns>
  public static DataSet GetDataSet(string SQL)
  {
   //System.Web.HttpContext.Current.Trace.Write("DBUtil.GetDataSet: " + SQL);
   // --- Verbindung aufbauen
   SqlConnection conn = new SqlConnection(DBConfig.CONN_MSSQL);
   conn.Open();
   // --- Befehl ausführen
   SqlCommand cmd = new SqlCommand(SQL, conn);
   // --- Datenadapter erzeugen
   SqlDataAdapter da = new SqlDataAdapter(cmd);
   // --- DataSet erzeugen
   DataSet ds = new DataSet();
   // --- Daten abholen
   da.Fill(ds);
   // --- Verbindung jetzt schon schließen! Rückgabe an den Connection Pool!!!
   conn.Close();

   // --- Zugriff auf die einzige Tabelle
   DataTable dt = ds.Tables[0];
   return ds;
  }

/// <summary>
  /// SQL-Befehle in einer Transaktion ausführen
/// </summary>
/// <param name="SQL"></param>
/// <returns></returns>
  public static long Execute(string SQL)
  {
   //System.Web.HttpContext.Current.Trace.Write("SQLUtil.Execute: " + SQL + " @ " + DBConfig.CONN_MSSQL);
   //System.Diagnostics.Trace.Write("SQLUtil.Execute: " + SQL + " @ " + DBConfig.CONN_MSSQL);
   SqlConnection sqlConn = new SqlConnection(DBConfig.CONN_MSSQL);
   sqlConn.Open();
   // Befehlsobjekt erzeugen
   SqlCommand sqlCmd = sqlConn.CreateCommand();
   sqlCmd.CommandText = SQL;
   long r = sqlCmd.ExecuteNonQuery();
   sqlConn.Close();
   return r;
  }

  /// <summary>
  /// Dataset aktualisieren mit Datenadapter
  /// </summary>
  /// <param name="ds"></param>
  /// <param name="sql"></param>
  public static void UpdateDS(DataSet ds, string sql)
  {
   // --- Verbindung aufbauen
   SqlConnection conn = new SqlConnection(DBConfig.CONN_MSSQL);
   conn.Open();
   // --- Befehl ausführen
   SqlCommand cmd = new SqlCommand(sql, conn);
   // --- Datenadapter erzeugen
   SqlDataAdapter da = new SqlDataAdapter(cmd);
   SqlCommandBuilder cb = new SqlCommandBuilder(da);
   da.Update(ds);
  }

  /// <summary>
  /// Datensätze zählen
  /// </summary>
  /// <param name="SQL"></param>
  /// <returns></returns>
  public static long Count(string SQL)
  {
   // Verbindung aufbauen
   SqlConnection sqlConn = new SqlConnection(DBConfig.CONN_MSSQL);
   sqlConn.Open();
   // Befehl ausführen
   SqlCommand sqlCmd = sqlConn.CreateCommand();
   sqlCmd.CommandText = SQL;
   // Datenreader erzeugen
   object zelle = sqlCmd.ExecuteScalar();
   return Convert.ToInt64(zelle);
  }

/// <summary>
  /// Warten auf Datenänderungen 
/// </summary>
/// <param name="SQL"></param>
/// <returns></returns>
  public static SqlDependency DeclareQueryNotfication(string SQL)
  {
   SqlConnection conn = new SqlConnection(DBConfig.CONN_MSSQL);
   conn.Open();
   SqlCommand cmd = new SqlCommand(SQL, conn);
   SqlDependency dep = new SqlDependency(cmd);
   try
   {

       SqlDependency.Start(conn.ConnectionString);
   }
   catch
   {
       throw new ApplicationException("Diese Datenbank unterstützt keine Query Notifications! Hinweis: SQL Server Express reicht für diese Funktion leider nicht!");
   }
   Console.WriteLine("SQLUtil.Dependency: " + SQL);
   cmd.ExecuteReader();
   return dep;
  }
 }


}




