﻿using System;
using System.Collections.Generic;
using System.Text;

namespace de.WWWings.ConsoleClient
{

 public class Program
 {

  /// <summary>
  /// Hauptprogramm der WWWings-Konsole
  /// </summary>
  /// <param name="args"></param>
  [STAThread]
  static void Main(string[] args)
  {

   //// Aufrufe hochzählen
   de.WWWings.Properties.Settings.Default.AnzahlAufrufDiesesBenutzers += 1;
   de.WWWings.Properties.Settings.Default.Save();

   if (args.Length > 0)
   {
    switch (args[0].ToString().ToLower())
    { // Spezielle Demos starten durch Kommandozeilenparameter
     case "init": WWWings.Test.InitDatabase.Init(); break;
     //case "change": new WWWings.DAL.Flug_DataManager().OneChange(); break;
     case "demos": de.WWWings.MiscDemos.DemoRunner.RunDemosInDemoViewer();
      de.ITVisions.DemoViewer.Viewer.AddAssembly(System.Reflection.Assembly.GetExecutingAssembly()); break;
     //new de.ITVisions.DemoViewer.Viewer(System.Reflection.Assembly.GetExecutingAssembly()); break;
     //case "dep": new de.WWWings..Notifications_Demos().run(); break;
    }
    Console.WriteLine("Ende des Programms!");
    Console.ReadLine();
   }
   else
   { // Konsolenbasiertes Hauptmenü
    Console.WriteLine("World Wide Wings Konsolen-Anwendung");
    Console.WriteLine(de.WWWings.Properties.Settings.Default.AnzahlAufrufDiesesBenutzers + ". Aufruf dieses Benutzers.\n");
    Hauptmenu_Anzeigen();
   }


   // Hinweis zum Aufruf der Beispiele:
   // Sie haben folgende Optionen:
   // 1. Aufruf des Demo-Viewers
   //new de.ITVisions.DemoViewer.Viewer(System.Reflection.Assembly.GetExecutingAssembly());

   // 2. Aufruf der Beispiele hier in main()
   //new de.WWWings.FCL.Netzwerk().NetStatus();
   //new de.WWWings.FCL.Netzwerk().NetStatusWarten();
   //new ConsoleUI_CS.ConfigurationDemos().Config_Demo();
   //new ConsoleUI_CS.ConfigurationDemos().Config_Verschlueseln();
   //FluggesellschaftClient.Run();
   //FluggesellschaftClient.DAL_Test2();
   //new ConfigurationDemos().demo();
   //new ConfigurationDemos().SettingsDemos();
   //etc.

  }


  /// <summary>
  /// Konsolenbasiertes Hauptmenü
  /// </summary>
  static void Hauptmenu_Anzeigen()
  {
   for (; ; )
   {
    Console.ForegroundColor = ConsoleColor.Yellow;
    Console.WriteLine("\nWorld Wide Wings - Konsole - HAUPTMENÜ\n");
    Console.WriteLine("A ... Alle Flüge ausgeben");
    Console.WriteLine("B ... Alle Flüge ausgeben (Seitenweises Abholen der Daten)");
    Console.WriteLine("C ... Alle Flüge auf der Strecke Berlin - München ausgeben");
    Console.WriteLine("F ... Daten zu einem Flug");
    Console.WriteLine("O ... Alle Flüge von einem Abflugort");
    Console.WriteLine("P ... Anzahl der freien Plätze ändern");
    Console.WriteLine("N ... Neuer Flug");
    Console.WriteLine("L ... Flug löschen");
    Console.WriteLine("U ... Probebuchung");
    Console.WriteLine("S ... Sonstige Demos (Demoviewer)");
    Console.WriteLine("I ... Flüge neu intialisieren");
    Console.WriteLine("J ... Passagiere neu intialisieren");
    Console.WriteLine("W ... Test-Workflow");
    Console.WriteLine("1 ... Demo 1: Lokale Datenbank");
    Console.WriteLine("2 ... Demo 2: Lokale Datenbank");
    Console.WriteLine("3 ... Demo 3: WCF Ein-Weg/Zwei-Weg)");
    Console.WriteLine("4 ... Demo 4: WCF Duplex");
    Console.WriteLine("5 ... Demo 5: WCF MSMQ");
    Console.WriteLine("E ... Programm beenden\n");
    Console.ForegroundColor = ConsoleColor.White;

    ConsoleKeyInfo k = Console.ReadKey(false);
    Console.WriteLine();
    switch (k.Key.ToString())
    {
     case "A":
      foreach (de.WWWings.Flug f in de.WWWings.FlugBLManager.HoleAlle())
      {
       Console.WriteLine("Flug {0} von {1} nach {2} am {3}.", f.FlugNr, f.AbflugOrt, f.ZielOrt, f.Datum);
      }
      break;

     case "B":
      AlleFluegeSeitenweiseAusgeben();
      break;

     case "C":
      foreach (de.WWWings.Flug f in de.WWWings.FlugBLManager.HoleAlle("Berlin", "München"))
      {
       Console.WriteLine("Flug {0} von {1} nach {2} am {3}.", f.FlugNr, f.AbflugOrt, f.ZielOrt, f.Datum);
      }
      break;
     case "F": throw new System.NotImplementedException("Funktion noch nicht vorhanden!"); break;
     case "O": throw new System.NotImplementedException("Funktion noch nicht vorhanden!"); break;
     case "P": throw new System.NotImplementedException("Funktion noch nicht vorhanden!"); break;
     case "N": throw new System.NotImplementedException("Funktion noch nicht vorhanden!"); break;
     case "L": throw new System.NotImplementedException("Funktion noch nicht vorhanden!"); break;
     case "I": WWWings.Test.InitDatabase.InitFluege(); break;
     case "J": WWWings.Test.InitDatabase.InitPassagiere(); break;
     case "U":
     case "D1": new FluggesellschaftClient().Demo1();
      break;
     case "D2": new FluggesellschaftClient().Demo2();
      break;
     case "D3":
      new WCFDemos().WCF_OneWayAndTwoWay(); break;
     case "D4":
      new WCFDemos().WCF_BspWCFDuplex(); break;
     case "D5":
      new WCFDemos().WCF_WarteschlangenDemo(); break;
     case "S":
      de.WWWings.MiscDemos.DemoRunner.RunDemosInDemoViewer();
      de.ITVisions.DemoViewer.Viewer.AddAssembly(System.Reflection.Assembly.GetExecutingAssembly()); break;
       case "W":
  WorkflowConsoleApplication.WorkflowHost.run(); break;

     case "E": return; break;
    }
   }

  }

  /// <summary>
  /// Client: Seitenweise Ausgabe aller Flüge
  /// </summary>
  private static void AlleFluegeSeitenweiseAusgeben()
  {
   de.WWWings.FlugMengePaging menge = new de.WWWings.FlugMengePaging(5);
   menge.SeitenWechsel += new EventHandler<PagingInfo>(menge_SeitenWechsel);
   foreach (de.WWWings.Flug f in menge)
   {
    Console.WriteLine("Flug {0} von {1} nach {2} am {3}.", f.FlugNr, f.AbflugOrt, f.ZielOrt, f.Datum);
   }
  }

  /// <summary>
  /// Ereignisbehandlung beim Seitenwechsel (Hilfsroutine für AlleFluegeSeitenweiseAusgeben)
  /// </summary>
  static void menge_SeitenWechsel(object sender, PagingInfo e)
  {
   Console.ForegroundColor = ConsoleColor.Yellow;
   Console.WriteLine("### Datenseite {0} von {1} mit {2} von insgesamt {3} Elementen:", e.AktuelleSeite, e.AnzahlSeiten, e.AnzahlObjekteInAktuellerSeite, e.AnzahlObjekteGesamt);
   Console.ForegroundColor = ConsoleColor.White;
  }
 }


}
//de.WWWings.Test.InitDatabase.InitFluegePlaetze(100);
// for (int i = 0; i < 100; i++)
// {
// new FluggesellschaftClient().Demo1();
//}

//de.WWWings.ConsoleClient.WCFClient.Test_mit_Zusammen_Generierten_Proxys();
//Console.WriteLine("ENDE");
//Console.ReadLine();

