﻿#region Using directives

using System;
using System.Collections.Generic;
using System.Text;

#endregion


using de.WWWings;
using de.WWWings.PassagierSystem;
using de.WWWings.MitarbeiterSystem;
using de.ITVisions.DemoViewer;

namespace de.WWWings.ConsoleClient
{

 /// <summary>
 /// Verschiedene Testdurchläufe für die GL und DAL
 /// </summary>
 [Demo]
 public class FluggesellschaftClient
 {

  /// <summary>
  /// Demo für Flugbuchung
  /// </summary>
  public void Demo1()
  {
   //de.WWWings.Test.InitDatabase.Init();

   Demo.Print(new de.WWWings.Test.Info().GetComponentInfoString());

   foreach (Flug f in de.WWWings.FlugBLManager.HoleAlle())
   {
    Demo.Print("Speichere Flug " + f.FlugNr);
    de.WWWings.FlugBLManager.SpeichereFlug(f);
   }

   Passagier p1 = de.WWWings.Passagier_BLManager.HolePassagier(96); // Passagier Max Fischer
   Demo.Print("Aktueller Passagier: " + p1.GanzerName);
   Demo.Print("Buchungen vorher: ");
   BuchungsMenge b = p1.AlleBuchungen();
   Demo.Print(b.ToString());
   Demo.Print("Buchungen gelöscht: " + p1.AlleBuchungenLoeschen());
   Demo.Print("Buchungen nach dem Löschen: ");
   Demo.Print(p1.AlleBuchungen().ToString());
   Demo.Print("Eine Einzelbuchung...");
   Demo.Print("Flug 504 gebucht. Buchungscode: " + p1.Buchen(101));
   Demo.Print("Eine Mehrfachbuchung...");
   long[] FlugNummern = new long[] { 123, 223, 288 };
   try
   {
    long Code = p1.Buchen(FlugNummern);
    foreach (long f in FlugNummern)
    {
     Demo.Print("Gebucht: Flug #" + f + " Buchungscode: " + Code);
    }
   }
   catch (ApplicationException ex2)
   {
    Demo.Print("Mehrfachbuchung nicht erfolgreich! " + ex2.GetType().ToString() + "." + ex2.Message);

   }
   catch (Exception ex)
   {
    Demo.Print("Ein unerwarteter Fehler ist aufgetreten " + ex.GetType().ToString() + "." + ex.Message);
   }

   Demo.Print("Buchungen nachher: ");
   Demo.Print(p1.AlleBuchungen().ToString());

  }

  /// <summary>
  /// Demo für zahlreiche Operationen mit der Geschäftslogik
  /// </summary>
  public void Demo2()
  {
   Console.WriteLine("Testcode für WWWings-Objektmodell");

   Passagier.CheckInStart += new Passagier.CheckInStartHandler(CheckInGestartet);
   Passagier.CheckInEnde += delegate(Passagier CheckedInPassagier)
   {
    Console.WriteLine("Check-In beendet: " + CheckedInPassagier.GanzerName + " fliegt mit Flug #" + CheckedInPassagier.AktuellerFlug.FlugNr);
   };

   Console.WriteLine("Erzeuge Flüge...");
   Flug f1 = new Flug(101, "Düsseldorf", "München");
   Flug f2 = new Flug(102, "Düsseldorf", "New York");
   Console.WriteLine("Erzeuge Passagiere...");
   Passagier p1 = new Passagier("Müller", "Hans");
   Passagier p2 = new Passagier("Meier", "Doris");
   Passagier p3 = new Passagier("Schulze", "Bernd");
   // Buchungen
   Console.WriteLine("Teste Buchungen...");
   p1.Buchen(f1);
   p2.Buchen(f2);
   f1 = f1 + p3;
   Console.WriteLine("Teste Check in...");
   /// Check-In
   p1.CheckIn(101);
   p2.CheckInAsync(102);

   try
   {
    p3.CheckIn(101);
   }
   catch (de.WWWings.PassagierSystem.PassagierNichtAufFlugGebucht)
   {
    Console.WriteLine("Einchecken nicht möglich, da Passagier nicht auf diesen Flug gebucht ist!");
   }
   catch (Exception ex)
   {
    Console.WriteLine("Es ist ein unerwarteter Fehler aufgetreten: " + ex.Message);
   }


   Console.WriteLine("Gesamtanzahl der Flüge: " + Flug.Fluege.Count);
   Console.WriteLine("Gesamtanzahl der Passagiere: " + Passagier.Passagiere.Count);
   foreach (Passagier p in Passagier.Passagiere.Values)
   {
    Console.WriteLine(p.GanzerName + " hat " + p.Fluege.Count + " gebucht!");
    if (!(p.AktuellerFlug == null))
    {
     Console.WriteLine("Aktueller Flug: " + p.AktuellerFlug.FlugNr);
    }
   }
   // Generische Typen nutzen
   Mitarbeiterzuordnung<Pilot, Pilot> CockpitTeam;
   Pilot Pilot1 = new Pilot("Müller", "Max");
   Pilot Pilot2 = new Pilot("Meier", "Hans");
   CockpitTeam = new Mitarbeiterzuordnung<Pilot, Pilot>(Pilot1, Pilot2);
   //f1.Pilot = Pilot1;

   // Typkonvertierungen
   Passagier pass = new Passagier("Schröder", "Gerhard");
   Person pers = new Person("Merkel", "Angela");
   pers = ((Person)pass);
   pass = (pers as Passagier);

   System.Collections.ArrayList a = new System.Collections.ArrayList();
   a.Add(new Object());

   pass = (a[0] as Passagier);
   //  pass = ((Passagier)a[0]);

   //  pass.Info();
   //  pers.Info();
   int zahl = 1;
   zahl++;
   //  string text = zahl;

   Console.WriteLine("Fertig!");
  }

  static void CheckInGestartet(Passagier pass)
  {
   Demo.Print("Check-In beginnt... für " + pass.GanzerName);
  }



  public void run_generics_demo()
  {

   // Untypisierter Mengentyp
   System.Collections.Queue CheckInWarteschlange1 =
     new System.Collections.Queue();
   CheckInWarteschlange1.Enqueue(new Passagier());
   CheckInWarteschlange1.Enqueue(new Mitarbeiter());
   CheckInWarteschlange1.Enqueue(new Flug());

   // Generischer Mengentyp
   System.Collections.Generic.Queue<Person> CheckInWarteschlange2 =
     new System.Collections.Generic.Queue<Person>();
   CheckInWarteschlange2.Enqueue(new Passagier());
   CheckInWarteschlange2.Enqueue(new Mitarbeiter());
   // CheckInWarteschlange2.Enqueue(new Flug());


  }
 }
}