﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using System.EnterpriseServices;
using System.Data.Common;

namespace de.ITVisions.DALUtil
{
 public class SQLUtil
 {
  public static SqlDataReader GetReader(string SQL)
  {
   // Verbindung aufbauen
   SqlConnection sqlConn = new SqlConnection(DBConfig.CONN_MSSQL);
   sqlConn.Open();
   // Befehl ausführen
   SqlCommand sqlCmd = sqlConn.CreateCommand();
   sqlCmd.CommandText = SQL;
   // Datenreader erzeugen
   SqlDataReader dr = sqlCmd.ExecuteReader();
   return dr;
  }

  public static DataTable GetDataTable(string SQL)
  {
   return GetDataSet(SQL).Tables[0];
  }

  // NEU !!!
  public static string[] GetColumn(string SQL)
  {
   DataTable dt = GetDataSet(SQL).Tables[0];
   string[] Werte = new string[dt.Rows.Count];
   for (int c = 0; c < dt.Rows.Count; c++)
   {
    Werte[c] = dt.Rows[c].ItemArray[0].ToString();
   }
   return Werte;
  }

  public static DataSet GetDataSet(string SQL)
  {
   //System.Web.HttpContext.Current.Trace.Write("DBUtil.GetDataSet: " + SQL);
   // --- Verbindung aufbauen
   SqlConnection conn = new SqlConnection(DBConfig.CONN_MSSQL);
   conn.Open();
   // --- Befehl ausführen
   SqlCommand cmd = new SqlCommand(SQL, conn);
   // --- Datenadapter erzeugen
   SqlDataAdapter da = new SqlDataAdapter(cmd);
   // --- DataSet erzeugen
   DataSet ds = new DataSet();
   // --- Daten abholen
   da.Fill(ds);
   // --- Verbindung jetzt schon schließen!
   conn.Close();
   // --- Zugriff auf die einzige Tabelle
   DataTable dt = ds.Tables[0];
   return ds;
  }

  // === SQL-Befehle in einer Transaktion ausführen
  public static long Execute(string SQL)
  {
   //System.Web.HttpContext.Current.Trace.Write("SQLUtil.Execute: " + SQL + " @ " + DBConfig.CONN_MSSQL);
   //Trace.Write("SQLUtil.Execute: " + SQL + " @ " + DBConfig.CONN_MSSQL);
   SqlConnection sqlConn = new SqlConnection(DBConfig.CONN_MSSQL);
   sqlConn.Open();
   // Befehlsobjekt erzeugen
   SqlCommand sqlCmd = sqlConn.CreateCommand();
   sqlCmd.CommandText = SQL;
   long r = sqlCmd.ExecuteNonQuery();
   sqlConn.Close();
   return r;
  }

  public static void UpdateDS(DataSet ds, string sql)
  {
   // --- Verbindung aufbauen
   SqlConnection conn = new SqlConnection(DBConfig.CONN_MSSQL);
   conn.Open();
   // --- Befehl ausführen
   SqlCommand cmd = new SqlCommand(sql, conn);
   // --- Datenadapter erzeugen
   SqlDataAdapter da = new SqlDataAdapter(cmd);
   SqlCommandBuilder cb = new SqlCommandBuilder(da);
   da.Update(ds);
  }

  public static long Count(string SQL)
  {
   // Verbindung aufbauen
   SqlConnection sqlConn = new SqlConnection(DBConfig.CONN_MSSQL);
   sqlConn.Open();
   // Befehl ausführen
   SqlCommand sqlCmd = sqlConn.CreateCommand();
   sqlCmd.CommandText = SQL;
   // Datenreader erzeugen
   object zelle = sqlCmd.ExecuteScalar();
   return Convert.ToInt64(zelle);
  }

  // === Warten auf Datenänderungen in der Flug-Tabelle
  public static SqlDependency DeclareQueryNotfication(string SQL)
  {
   SqlConnection conn = new SqlConnection(DBConfig.CONN_MSSQL);
   conn.Open();
   SqlCommand cmd = new SqlCommand(SQL, conn);
   SqlDependency dep = new SqlDependency(cmd);
   SqlDependency.Start(conn.ConnectionString);
   Console.WriteLine("SQLUtil.Dependency: " + SQL);
   cmd.ExecuteReader();
   return dep;
  }
 }


}




