Imports Microsoft.VisualBasic
Imports System
Imports System.Collections.Generic
Imports System.Data
Imports System.Data.Common
Imports System.Data.SqlClient
Imports de.WWWings
Imports de.ITVisions.DALUtil
Imports System.EnterpriseServices
Imports System.Runtime.CompilerServices

Namespace de.WWWings.DAL
 ''' <summary>
 ''' Datenzugriffsmanager fr die Tabelle Fluege
 ''' Verwendet Transaktionen in Enterprise Services
 ''' </summary>
 <Description("Flugmanager fr WorldWideWings"), System.EnterpriseServices.Synchronization(SynchronizationOption.Required), Transaction(TransactionOption.Required), ObjectPoolingAttribute(True, 10, 20), EventTrackingEnabled(True), System.Runtime.InteropServices.Guid("9C74BA6A-9D1C-4fe7-808E-04E6665D0251")> _
 Public Class Flug_DataManager : Inherits ServicedComponent

  ''' <summary>
  ''' Festlegen der Datenbank beim Starten der Klasse
  ''' </summary>
  Public Sub New()
   DBUtil.SetDatabase(DBUtil.Providers.MSSQL, DBConfig.CONN_MSSQL)
  End Sub
  ' ---------------------------------------------------
#Region "Datenstze zhlen"
  ''' <summary>
  ''' Anzahl der Datenstze ermitteln
  ''' </summary>
  ''' <returns></returns>
  Public Function Count() As Integer
   Return CInt(DBUtil.Count("Select count(*) from FL_Fluege"))
  End Function

  ''' <summary>
  ''' Anzahl der Datenstze ermitteln fr einen Abflugort
  ''' </summary>
  ''' <returns></returns>
  Public Function Count(ByVal Abflugort As String) As Integer
   Return CInt(DBUtil.Count("Select count(*) from FL_Fluege where FL_Abflugort='" & Abflugort & "'"))
  End Function
#End Region
  ' ---------------------------------------------------
#Region "Daten lesen ohne Filtern"


  ''' <summary>
  ''' Diese Methode liefert eine Liste aller Abflughfen in Form eines String-Array
  ''' </summary>
  ''' <returns>String-Array mit Abflugorten</returns>
  Public Shared Function AlleAbflughaefen() As String()
   Const SQL As String = "Select FL_Abflugort from FL_Fluege group by FL_Abflugort"
   Return SQLUtil.GetColumn(SQL)
  End Function

  Public Shared Function AlleAbflughaefen_DS() As DataSet
   Const SQL As String = "Select Fl_Abflugort from FL_Fluege group by Fl_Abflugort"
   Return SQLUtil.GetDataSet(SQL)
  End Function

  ''' <summary>
  ''' Liste aller Flge
  ''' </summary>
  ''' <returns>Dataset</returns>
  Public Shared Function AlleFluege_DS() As DataSet
   Const SQL As String = "Select * from FL_Fluege"
   Return SQLUtil.GetDataSet(SQL)
  End Function

  ''' <summary>
  ''' Liste aller Flge (mit Paging)
  ''' </summary>
  ''' <param name="von"></param>
  ''' <param name="Anzahl"></param>
  ''' <returns></returns>
  Public Shared Function AlleFluege_DS(ByVal von As Long, ByVal Anzahl As Long) As DataSet
   Dim bis As Long = von + Anzahl
   Dim SQL As String = "With ordered as (Select Row_Number() Over (order by FL_FlugNr) as RowNumber, * from FL_Fluege) Select * from ordered where RowNumber between " & von & " and " & bis
   Return SQLUtil.GetDataSet(SQL)
  End Function

  ''' <summary>
  ''' Liste aller Flge (mit Paging und Sortieren)
  ''' </summary>
  ''' <param name="sort"></param>
  ''' <param name="von"></param>
  ''' <param name="bis"></param>
  ''' <returns>Datatable</returns>
  Public Shared Function AlleFluege_DT(ByVal sort As String, ByVal von As Long, ByVal bis As Long) As DataTable
   Return AlleFluege_DS(sort, von, bis).Tables(0)
  End Function

  ''' <summary>
  ''' Liste aller Flge (mit Paging und Sortieren)
  ''' </summary>
  ''' <param name="sort"></param>
  ''' <param name="von"></param>
  ''' <param name="bis"></param>
  ''' <returns>Dataset</returns>
  Public Shared Function AlleFluege_DS(ByVal sort As String, ByVal von As Long, ByVal bis As Long) As DataSet
   If sort = "" Then
    Return AlleFluege_DS(von, bis)
   End If
   Dim SQL As String = "With ordered as (Select Row_Number() Over (order by FL_FlugNr) as RowNumber, * from FL_Fluege order by " & sort & ") Select * from ordered where RowNumber between " & von & " and " & bis
   Return SQLUtil.GetDataSet(SQL)
  End Function
#End Region
  ' ---------------------------------------------------
#Region "Daten lesen mit Filtern"
  ''' <summary>
  ''' Diese Methode liefert eine Liste aller Flge von einem Abflugort
  ''' </summary>
  ''' <param name="Fl_Abflugort">Name des Ablfugortes</param>
  ''' <returns></returns>
  Public Shared Function AlleFluege_DS(ByVal Fl_Abflugort As String) As DataSet
   If Fl_Abflugort = "*" Then Return AlleFluege_DS()
   Dim SQL As String = "Select * from FL_Fluege where Fl_Abflugort = '" & Fl_Abflugort & "'"
   Return SQLUtil.GetDataSet(SQL)
  End Function


  ''' <summary>
  ''' Liste aller Flge zu einem Zielort
  ''' </summary>
  ''' <param name="fl_Zielort">Name </param>
  ''' <returns></returns>
  Public Shared Function AlleFluege_Zielort(ByVal fl_Zielort As String) As DataSet
   If fl_Zielort = "*" Then Return AlleFluege_DS()
   Dim SQL As String = "Select * from FL_Fluege where Fl_Zielort='" & fl_Zielort & "'"
   Return SQLUtil.GetDataSet(SQL)
  End Function

  ''' <summary>
  ''' Alle Flge auf einer bestimmten Route
  ''' </summary>
  ''' <returns></returns>
  Public Shared Function AlleFluege_Strecke(ByVal Fl_Abflugort As String, ByVal fl_Zielort As String) As DataSet
   If Fl_Abflugort = "*" Then Return AlleFluege_Zielort(fl_Zielort)
   If fl_Zielort = "*" Then Return AlleFluege_DS(Fl_Abflugort)
   Dim SQL As String = "Select * from FL_Fluege where Fl_Abflugort = '" & Fl_Abflugort & "' and Fl_Zielort='" & fl_Zielort & "'"
   Return SQLUtil.GetDataSet(SQL)
  End Function

  ''' <summary>
  ''' Alle Flge auf einer bestimmten Route
  ''' </summary>
  ''' <param name="Abflughafen"></param>
  ''' <param name="FL_Zielflughafen"></param>
  ''' <returns></returns>
  Public Shared Function AlleFluegeRoute(ByVal Abflughafen As String, ByVal FL_Zielflughafen As String) As DataSet
   Return AlleFluege_Strecke(Abflughafen, FL_Zielflughafen)
  End Function



  ''' <summary>
  ''' Liste aller Flge von einem Abflugort (mit Paging und Sortieren)
  ''' </summary>
  ''' <param name="Abflugort"></param>
  ''' <param name="sort"></param>
  ''' <param name="von"></param>
  ''' <param name="bis"></param>
  ''' <returns></returns>
  Public Shared Function AlleFluege_DS(ByVal Abflugort As String, ByVal sort As String, ByVal von As Long, ByVal bis As Long) As DataSet
   If sort = "" Then
    Return AlleFluegeNachOrt_DS(Abflugort, von, bis)
   End If
   Dim SQL As String = "With ordered as (Select Row_Number() Over (order by FL_FlugNr) as RowNumber, * from FL_Fluege where Fl_Abflugort='" & Abflugort & "' ) Select * from ordered where RowNumber between " & von & " and " & bis & " order by " & sort
   Return SQLUtil.GetDataSet(SQL)
  End Function

  ''' <summary>
  ''' Liste aller Flge von einem Abflugort (mit Paging)
  ''' </summary>
  ''' <param name="Abflugort"></param>
  ''' <param name="von"></param>
  ''' <param name="Anzahl"></param>
  ''' <returns></returns>
  Public Shared Function AlleFluegeNachOrt_DS(ByVal Abflugort As String, ByVal von As Long, ByVal Anzahl As Long) As DataSet
   Dim bis As Long = von + Anzahl
   Dim SQL As String = "With ordered as (Select Row_Number() Over (order by FL_FlugNr) as RowNumber, * from FL_Fluege where Fl_Abflugort='" & Abflugort & "' ) Select * from ordered where RowNumber between " & von & " and " & bis
   Return SQLUtil.GetDataSet(SQL)
  End Function
#End Region
  ' ---------------------------------------------------
#Region "Datenstze verndern"
  ''' <summary>
  ''' Zurckschreiben eines Dataset Diffgrams
  ''' </summary>
  ''' <param name="ds"></param>
  Public Shared Sub Update(ByVal ds As DataSet)
   SQLUtil.UpdateDS(ds, "Select * from FL_fluege")
  End Sub

  ''' <summary>
  ''' Zurckschreiben eines einzelnen Flug-Datensatz
  ''' </summary>
  ''' <param name="FL_Abflugort"></param>
  ''' <param name="FL_ZielOrt"></param>
  ''' <param name="FL_Plaetze"></param>
  ''' <param name="original_Fl_FlugNr"></param>
  Public Shared Sub Update(ByVal FL_Abflugort As String, ByVal FL_ZielOrt As String, ByVal FL_Plaetze As Long, ByVal original_Fl_FlugNr As Long)
   SQLUtil.Execute("UPDATE Fl_Fluege SET FL_Abflugort = '" & FL_Abflugort & "', FL_ZielOrt = '" & FL_ZielOrt & "', FL_Plaetze = " & FL_Plaetze & " WHERE Fl_FlugNr = " & original_Fl_FlugNr)
   Return
  End Sub

  ''' <summary>
  ''' Zurckschreiben eines einzelnen Flug-Datensatz
  ''' </summary>
  ''' <param name="FL_Abflugort"></param>
  ''' <param name="FL_ZielOrt"></param>
  ''' <param name="FL_Plaetze"></param>
  ''' <param name="FL_NichtRaucherFlug"></param>
  ''' <param name="FL_EingerichtetAm"></param>
  ''' <param name="original_Fl_FlugNr"></param>
  Public Shared Sub Update(ByVal FL_Abflugort As String, ByVal FL_ZielOrt As String, ByVal FL_Plaetze As Long, ByVal FL_NichtRaucherFlug As Boolean, ByVal FL_EingerichtetAm As DateTime, ByVal original_Fl_FlugNr As Integer)
   SQLUtil.Execute("UPDATE Fl_Fluege SET FL_Abflugort = '" & FL_Abflugort & "', FL_ZielOrt = '" & FL_ZielOrt & "', FL_Plaetze = " & FL_Plaetze & " WHERE Fl_FlugNr = " & original_Fl_FlugNr)

  End Sub

  ''' <summary>
  ''' Zurckschreiben eines einzelnen Flug-Datensatz
  ''' </summary>
  ''' <param name="FL_Abflugort"></param>
  ''' <param name="FL_ZielOrt"></param>
  ''' <param name="FL_Datum"></param>
  ''' <param name="FL_NichtRaucherFlug"></param>
  ''' <param name="FL_Plaetze"></param>
  ''' <param name="FL_FreiePlaetze"></param>
  ''' <param name="FL_PI_MI_MitarbeiterNr"></param>
  ''' <param name="FL_AnzahlStarts"></param>
  ''' <param name="FL_EingerichtetAm"></param>
  ''' <param name="Fl_FlugNr"></param>
  Public Shared Sub Update(ByVal FL_Abflugort As String, ByVal FL_ZielOrt As String, ByVal FL_Datum As DateTime, ByVal FL_NichtRaucherFlug As Boolean, ByVal FL_Plaetze As Long, ByVal FL_FreiePlaetze As Integer, ByVal FL_PI_MI_MitarbeiterNr As Long, ByVal FL_AnzahlStarts As Long, ByVal FL_EingerichtetAm As DateTime, ByVal Fl_FlugNr As Integer)
   SQLUtil.Execute("UPDATE Fl_Fluege SET FL_Abflugort = '" & FL_Abflugort & "', FL_ZielOrt = '" & FL_ZielOrt & "', FL_Plaetze = " & FL_Plaetze & " WHERE Fl_FlugNr = " & Fl_FlugNr)

  End Sub

  ''' <summary>
  ''' Hinzufgen eines Flugs
  ''' </summary>
  ''' <param name="FL_Abflugort"></param>
  ''' <param name="FL_ZielOrt"></param>
  ''' <param name="FL_NichtRaucherFlug"></param>
  ''' <param name="FL_Plaetze"></param>
  ''' <param name="FL_EingerichtetAm"></param>
  ''' <param name="FL_FlugNr"></param>
  Public Shared Sub Insert(ByVal FL_Abflugort As String, ByVal FL_ZielOrt As String, ByVal FL_NichtRaucherFlug As Boolean, ByVal FL_Plaetze As Long, ByVal FL_EingerichtetAm As DateTime, ByVal FL_FlugNr As Integer)
   SQLUtil.Execute("Insert into Fl_Fluege (Fl_Flugnr, FL_Abflugort, Fl_Zielort, Fl_Plaetze, Fl_NichtraucherFlug) Values (" & FL_FlugNr & ",'" & FL_Abflugort & "', '" & FL_ZielOrt & "', " & FL_Plaetze & ", '" & FL_NichtRaucherFlug & "')")

  End Sub

  ''' <summary>
  ''' Hinzufgen eines Flugs
  ''' </summary>
  ''' <param name="FL_Abflugort"></param>
  ''' <param name="FL_ZielOrt"></param>
  ''' <param name="FL_NichtRaucherFlug"></param>
  ''' <param name="FL_Plaetze"></param>
  ''' <param name="FL_FreiePlaetze"></param>
  ''' <param name="FL_Datum"></param>
  ''' <param name="FL_EingerichtetAm"></param>
  ''' <param name="FL_FlugNr"></param>
  Public Shared Sub Insert(ByVal FL_Abflugort As String, ByVal FL_ZielOrt As String, ByVal FL_NichtRaucherFlug As Boolean, ByVal FL_Plaetze As Long, ByVal FL_FreiePlaetze As Long, ByVal FL_Datum As DateTime, ByVal FL_EingerichtetAm As DateTime, ByVal FL_FlugNr As Integer)
   DBUtil.Execute("Insert into Fl_Fluege (Fl_Flugnr, FL_Abflugort, Fl_Zielort, FL_Datum, Fl_Plaetze, Fl_FreiePlaetze,Fl_NichtraucherFlug) Values (" & FL_FlugNr & ",'" & FL_Abflugort & "', '" & FL_ZielOrt & "', '" & FL_Datum.ToString(New System.Globalization.CultureInfo("en-us")) & "'," & FL_Plaetze & ", " & FL_FreiePlaetze & ",'" & FL_NichtRaucherFlug & "')")

  End Sub

  ''' <summary>
  ''' Hinzufgen eines Flugs
  ''' </summary>
  ''' <param name="FL_Abflugort"></param>
  ''' <param name="FL_Zielort"></param>
  ''' <param name="FL_Datum"></param>
  ''' <param name="FL_NichtRaucherFlug"></param>
  ''' <param name="FL_Plaetze"></param>
  ''' <param name="FL_FreiePlaetze"></param>
  ''' <param name="FL_PI_MI_MitarbeiterNr"></param>
  ''' <param name="FL_AnzahlStarts"></param>
  ''' <param name="FL_EingerichtetAm"></param>
  ''' <param name="Fl_FlugNr"></param>
  Public Shared Sub Insert(ByVal FL_Abflugort As String, ByVal FL_Zielort As String, ByVal FL_Datum As DateTime, ByVal FL_NichtRaucherFlug As Boolean, ByVal FL_Plaetze As Long, ByVal FL_FreiePlaetze As Long, ByVal FL_PI_MI_MitarbeiterNr As Long, ByVal FL_AnzahlStarts As Long, ByVal FL_EingerichtetAm As DateTime, ByVal Fl_FlugNr As Integer)
   SQLUtil.Execute("Insert into Fl_Fluege (Fl_Flugnr, FL_Abflugort, Fl_Zielort, FL_Datum, Fl_Plaetze, Fl_FreiePlaetze,Fl_NichtraucherFlug) Values (" & Fl_FlugNr & ",'" & FL_Abflugort & "', '" & FL_Zielort & "', '" & FL_Datum.ToString(New System.Globalization.CultureInfo("en-us")) & "'," & FL_Plaetze & ", " & FL_FreiePlaetze & ",'" & FL_NichtRaucherFlug & "')")
  End Sub

  ''' <summary>
  ''' Lschen eines Flugs
  ''' </summary>
  ''' <param name="Original_Fl_FlugNr"></param>
  Public Shared Sub LoescheFlug(ByVal Original_Fl_FlugNr As Integer)
   SQLUtil.Execute("Delete from Fl_Fluege where Fl_FlugNr = " & Original_Fl_FlugNr & "")
  End Sub
#End Region
  ' ---------------------------------------------------
#Region "berwachen auf Vernderungen"
  Public Delegate Sub FluegeWurdenAktualisiertHandler()
  Public Event FluegeWurdenAktualisiert As FluegeWurdenAktualisiertHandler
  Private dep As System.Data.SqlClient.SqlDependency

  ''' <summary>
  ''' Initalisierung der Benachrichtung ber Datennderungen
  ''' </summary>
  ''' <param name="Zielort"></param>
  Public Sub AktualisierungenMelden(ByVal Zielort As String)
   dep = SQLUtil.DeclareQueryNotfication("Select FL_FlugNr,Fl_Abflugort, FL_Zielort, Fl_Plaetze, Fl_FreiePlaetze from dbo.FL_Fluege where FL_zielort = '" & Zielort & "'")

   AddHandler dep.OnChange, AddressOf dep_OnChange


  End Sub

  ''' <summary>
  ''' Reaktion auf Datennderungen
  ''' </summary>
  ''' <param name="sender"></param>
  ''' <param name="e"></param>
  Private Sub dep_OnChange(ByVal sender As Object, ByVal e As SqlNotificationEventArgs)
   If e.Type = SqlNotificationType.Subscribe Then
    Throw New Exception("Fehler in Query Notification: " & e.Info.ToString())
   Else
    If Not FluegeWurdenAktualisiertEvent Is Nothing Then
     RaiseEvent FluegeWurdenAktualisiert()
    End If
   End If
  End Sub

#End Region
  ' ---------------------------------------------------
#Region "Einsatz von Datareadern zum Datenlesen (Alternative Implementierung)"

  ''' <summary>
  ''' Flge lesen mit einem DataReader
  ''' </summary>
  ''' <returns>Geffneter DataReader</returns>
  Public Function AlleFluege_DR() As SqlDataReader
   Const SQL As String = "Select * from FL_Fluege"
   Return SQLUtil.GetReader(SQL)
  End Function

  ''' <summary>
  ''' Flge lesen mit einem DataReader (Gefiltert)
  ''' </summary>
  ''' <returns>Geffneter DataReader</returns>
  Public Function AlleFluegeFuerAbflughafen_DR(ByVal Abflughafen As String) As SqlDataReader
   Dim SQL As String = "Select * from FL_Fluege where Fl_Abflugort = '" & Abflughafen & "'"
   Return SQLUtil.GetReader(SQL)
  End Function


  ''' <summary>
  ''' Einen Flug holen anhand seiner Flugnummer
  ''' </summary>
  ''' <returns>Geffneter DataReader</returns>
  Public Function GetFlug_DR(ByVal FlugNr As Long) As SqlDataReader
   Dim SQL As String = "Select * from FL_Fluege where fl_flugnr = " & FlugNr & ""
   Dim dr As SqlDataReader = SQLUtil.GetReader(SQL)
   dr.Read()
   Return dr
  End Function
#End Region

 End Class
End Namespace
