﻿using System;
using de.WWWings;

namespace de.WWWings
{
 /// <summary>
 /// FlugBLManager ist der Geschäftslogikmanager für die Flug-Klasse.
 /// Implementierungsalternative 1: mit ORM-Mapping
 /// </summary>
 [System.ComponentModel.DataObject()]
 public class FlugBLManager : System.MarshalByRefObject, de.WWWings.Manager.IFlugBLManager // Vererbung und Schnittstelle nur für .NET Remoting !!!
 {
  /// <summary>
  /// Liefert Infos über dieses Objekt an den Aufrufer
  /// Wird verwendet für .NET Remoting-Demos!
  /// </summary>
  public string FlugListe // 
  {
   get
   {
    return ("Abruf der Flugliste im Prozess " + "Diese Objekt läuft in der Assembly " + System.Reflection.Assembly.GetExecutingAssembly().GetName().FullName + " in dem Prozess " + System.Windows.Forms.Application.StartupPath);
   }
  }


  /// <summary>
  /// Holt liste der Abflugorte
  /// </summary>
  /// <returns></returns>
  public static string[] Abflugorte()
  {
   return DAL.Flug_DataManager.AlleAbflughaefen();
  }

  public static string[] Ziele_Fuer_Abflugort(string Abflugort)
  {
   System.Data.DataTable dt = DAL.Flug_DataManager.AlleFluege_DS(Abflugort).Tables[0];

   System.Collections.Generic.List<string> Ziele = new System.Collections.Generic.List<string>();
   string[] Werte = new string[dt.Rows.Count];
   for (int c = 0; c < dt.Rows.Count; c++)
   {
    string Ziel = dt.Rows[c]["Fl_Zielort"].ToString();
    if (!Ziele.Contains(Ziel)) Ziele.Add(Ziel);
   }
   return Ziele.ToArray();
  }

  public static System.Data.DataSet Abflugorte_DS()
  {
   return DAL.Flug_DataManager.AlleAbflughaefen_DS();
  }




  /// <summary>
  /// Zähle die Anzahl der Flüge in der Datenbank
  /// </summary>
  /// <returns>Gesamtanzahl der Flüge</returns>
  [Obsolete("Bitte verwenden Sie AnzFluege()!")]
  public System.Int32 Count()
  {
   return DAL.Flug_DataManager.Count();
  }

  /// <summary>
  /// Zähle die Anzahl der Flüge in der Datenbank
  /// </summary>
  /// <returns>Gesamtanzahl der Flüge</returns>
  public static System.Int32 AnzFluege()
  {
   return DAL.Flug_DataManager.Count();
  }


  /// <summary>
  /// Zähle die Anzahl der Flüge im RAM
  /// </summary>
  /// <returns>Gesamtanzahl der Flüge</returns>
  public System.Int32 Count_RAM()
  {
   return Flug.Fluege.Count;
  }

  /// <summary>
  /// Zähle die Anzahl der Flüge für einen bestimmten Abflugort.
  /// </summary>
  /// <returns>Gesamtanzahl der Flüge</returns>
  public System.Int32 Count(string Abflugort)
  {
   return DAL.Flug_DataManager.Count(Abflugort);
  }

  /// <summary>
  /// Holle alle Flüge
  /// </summary>
  /// <returns>Mengen von Flügen</returns>
  [System.ComponentModel.DataObjectMethod(System.ComponentModel.DataObjectMethodType.Select)]
  public static FlugMenge HoleAlle()
  {
   return ORM.ORM_Flug.MapTable(DAL.Flug_DataManager.AlleFluege_DS().Tables[0]);
  }

  /// <summary>
  /// Holle alle Flüge für einen Abflufhafen
  /// </summary>
  /// <returns>Mengen von Flügen</returns>
  [System.ComponentModel.DataObjectMethod(System.ComponentModel.DataObjectMethodType.Select)]
  public static FlugMenge HoleAlle(string FL_Abflughafen)
  {
   return ORM.ORM_Flug.MapTable(DAL.Flug_DataManager.AlleFluege_DS(FL_Abflughafen).Tables[0]);
  }


  /// <summary>
  /// Holle alle Flüge für eine bestimmte Strecke
  /// </summary>
  /// <returns>Mengen von Flügen</returns>
  [System.ComponentModel.DataObjectMethod(System.ComponentModel.DataObjectMethodType.Select)]
  public static FlugMenge HoleAlle(string FL_Abflughafen, string FL_Zielhafen)
  {
   return ORM.ORM_Flug.MapTable(DAL.Flug_DataManager.AlleFluege_Strecke(FL_Abflughafen, FL_Zielhafen).Tables[0]);
  }

  /// <summary>
  /// Holle alle Flüge mit SQL 2005 Paging
  /// </summary>
  /// <returns>Mengen von Flügen</returns>
  [System.ComponentModel.DataObjectMethod(System.ComponentModel.DataObjectMethodType.Select)]
  public static FlugMenge HoleAlle(System.Int32 Anzahl, System.Int32 Start)
  {
   if (Anzahl == -1) return HoleAlle();

   System.Data.DataTable dt = DAL.Flug_DataManager.AlleFluege_DS(Start, Anzahl).Tables[0];
   //TODO: Refactoring: Hier besser eine eigene Hilfsroutine MapTable()
   FlugMenge ff = new FlugMenge();
   foreach (System.Data.DataRow dr in dt.Rows)
   {
    Flug f = ORM.ORM_Flug.MapRow(dr);
    ff.Add(f);
   }
   return ff;
  }

  /// <summary>
  /// Holle alle Flüge mit SQL 2005 Paging und Sortieren!
  /// </summary>
  /// <returns></returns>
  //[System.ComponentModel.DataObjectMethod(System.ComponentModel.DataObjectMethodType.Select)]
  //public static FlugMenge HoleAlle(System.String Sortierung, System.Int32 Anzahl, System.Int32 Start)
  //{
  // if (Anzahl == -1) return HoleAlle();
  // System.Int32 c = 0;
  // FlugMenge ff = new FlugMenge();
  // foreach (System.Data.DataRow dr in DAL.Flug_DataManager.AlleFluege_DS(Sortierung, Start, Start + Anzahl).Tables[0].Rows)
  // {
  //  Flug f = Map(dr);
  //  ff.Add(f);
  // }
  // return ff;
  //}

  [System.ComponentModel.DataObjectMethod(System.ComponentModel.DataObjectMethodType.Select)]
  public static FlugMenge HoleAlle(System.String Abflugort, System.Int32 Anzahl, System.Int32 Start)
  {
   return HoleAlle(Abflugort, "", Anzahl, Start);
  }


  /// <summary>
  /// Holle alle Flüge mit Filtern, SQL 2005 Paging und Sortieren!
  /// </summary>
  /// <returns></returns>
  [System.ComponentModel.DataObjectMethod(System.ComponentModel.DataObjectMethodType.Select)]
  public static FlugMenge HoleAlle(System.String Abflugort, System.String Sortierung, System.Int32 Anzahl, System.Int32 Start)
  {
   FlugMenge ff = new FlugMenge();
   if (Anzahl >= 0)
   {
    ff = ORM.ORM_Flug.MapTable(DAL.Flug_DataManager.AlleFluege_DS(Abflugort, Sortierung, Start, Start + Anzahl).Tables[0]);
   }
   else
   {
    if (Sortierung == "") Sortierung = "Fl_FlugNr";
    ff = ORM.ORM_Flug.MapTable(DAL.Flug_DataManager.AlleFluege_DS_Sort(Abflugort, Sortierung).Tables[0]);
   }
   return ff;
  }


  /// <summary>
  /// Hole einen Flug
  /// </summary>
  [System.ComponentModel.DataObjectMethod(System.ComponentModel.DataObjectMethodType.Select)]
  public static de.WWWings.Flug HoleFlug(long FlugNr)
  {

   if (FlugNr <= 0) return null; // TODO: Exceptionvermeidung
   System.Data.DataRow dr = new de.WWWings.DAL.Flug_DataManager().GetFlug(FlugNr);
   Flug f = ORM.ORM_Flug.MapRow(dr);
   return f;
  }

  /// <summary>
  /// Speichern eines bereits vorher geladenen Flugs
  /// </summary>
  /// <param name="f">Das zu speichernde Flugobjket</param>
  [System.ComponentModel.DataObjectMethod(System.ComponentModel.DataObjectMethodType.Update)]
  public static void SpeichereFlug(Flug f)
  {
   // ggf Konsistenzprüfungen
   de.WWWings.DAL.Flug_DataManager.Update(f.AbflugOrt, f.ZielOrt, f.Plaetze, f.FlugNr);
  }

  /// <summary>
  /// Löschen eines Flugs
  /// </summary>
  /// <param name="f">Flug-Objekt für den löschenden Flug</param>
  [System.ComponentModel.DataObjectMethod(System.ComponentModel.DataObjectMethodType.Delete)]
  public static void LoescheFlug(Flug f)
  {
   de.WWWings.DAL.Flug_DataManager.LoescheFlug((int)f.FlugNr);
  }

  /// <summary>
  /// Speichern eines bereits vorher geladenen Flugs
  /// </summary>
  /// <param name="FL_Abflugort"></param>
  /// <param name="FL_ZielOrt"></param>
  /// <param name="FL_Plaetze"></param>
  /// <param name="FL_NichtRaucherFlug"></param>
  /// <param name="FL_EingerichtetAm"></param>
  /// <param name="original_Fl_FlugNr"></param>
  [System.ComponentModel.DataObjectMethod(System.ComponentModel.DataObjectMethodType.Update)]
  public static void SpeichereFlug(string FL_Abflugort, string FL_ZielOrt, long FL_Plaetze, bool FL_NichtRaucherFlug, DateTime FL_EingerichtetAm, int original_Fl_FlugNr)
  {
   de.WWWings.DAL.Flug_DataManager.Update(FL_Abflugort, FL_ZielOrt, FL_Plaetze, FL_NichtRaucherFlug, FL_EingerichtetAm, original_Fl_FlugNr);
  }



  public bool Ping()
  {
   return true;
  }
 }
}


///// <summary>
///// Typischer OR-Mapping-Code
///// </summary>
//public static Fluege Alle()
//{
// Fluege ff = new Fluege();
// foreach (System.Data.DataRow dr in Fluege.AlleFluege_DS().Tables[0].Rows)
// {
//  Flug f = new Flug(dr);
//  ff.Add(f.FlugNr, f);
// }
// return ff;
//}

/// <summary>
/// Holle alle Flüge mit primitivem Paging
/// </summary>
/// <returns></returns>
//public static FlugMenge HoleAlle(System.Int32 maximumRows, System.Int32 startRowIndex)
//{
// System.Int32 c = 0;
// FlugMenge ff = new FlugMenge();
// foreach (System.Data.DataRow dr in Fluege.AlleFluege_DS().Tables[0].Rows)
// {
//  if ((c >= startRowIndex) && (c < startRowIndex + maximumRows))
//  {
//   Flug f = Map(dr);
//   ff.Add(f);
//  }
//  c++;
// }
// return ff;
//}