Imports Microsoft.VisualBasic
Imports System
Imports de.WWWings

Namespace de.WWWings
 ''' <summary>
 ''' FlugBLManager ist der Geschftslogikmanager fr die Flug-Klasse.
 ''' Implementierungsalternative 1: mit ORM-Mapping
 ''' </summary>
 <System.ComponentModel.DataObject()> _
 Public Class FlugBLManager

  ''' <summary>
  '''  
  ''' </summary>
  ''' <returns></returns>
  Public Shared Function Abflugorte() As String()
   Return DAL.Flug_DataManager.AlleAbflughaefen()
  End Function

  Public Shared Function Ziele_Fuer_Abflugort(ByVal Abflugort As String) As String()
   Dim dt As System.Data.DataTable = DAL.Flug_DataManager.AlleFluege_DS(Abflugort).Tables(0)

   Dim Ziele As System.Collections.Generic.List(Of String) = New System.Collections.Generic.List(Of String)()
   Dim Werte As String() = New String(dt.Rows.Count - 1) {}
   Dim c As Integer = 0
   Do While c < dt.Rows.Count
    Dim Ziel As String = dt.Rows(c)("Fl_Zielort").ToString()
    If (Not Ziele.Contains(Ziel)) Then
     Ziele.Add(Ziel)
    End If
    c += 1
   Loop
   Return Ziele.ToArray()
  End Function

  Public Shared Function Abflugorte_DS() As System.Data.DataSet
   Return DAL.Flug_DataManager.AlleAbflughaefen_DS()
  End Function

#Region "Mapping"
  ''' <summary>
  ''' Mapping fr DataRow
  ''' </summary>
  Public Shared Function Map(ByVal dr As System.Data.DataRow) As Flug
   Dim f As Flug = New Flug()
   f.FlugNr = Convert.ToInt64(dr("fl_flugnr"))
   f.AbflugOrt = dr("fl_AbflugOrt").ToString()
   f.ZielOrt = dr("fl_ZielOrt").ToString()
   f.Plaetze = Convert.ToInt64(dr("fl_Plaetze").ToString())
   f.FreiePlaetze = Convert.ToInt64(dr("fl_FreiePlaetze").ToString())
   f.Nichtraucherflug = Convert.ToBoolean(dr("fl_nichtraucherflug"))
   Return f
  End Function

  ''' <summary>
  ''' Mapping fr DataRreader
  ''' </summary>
  Public Shared Function Map(ByVal dr As System.Data.IDataReader) As Flug
   Dim f As Flug = New Flug()
   f.FlugNr = Convert.ToInt64(dr("fl_flugnr"))
   f.AbflugOrt = dr("fl_AbflugOrt").ToString()
   f.ZielOrt = dr("fl_ZielOrt").ToString()
   f.Plaetze = Convert.ToInt64(dr("fl_Plaetze"))
   f.FreiePlaetze = Convert.ToInt64(dr("fl_FreiePlaetze"))
   Return f
  End Function

  ''' <summary>
  ''' Mapping fr DataTable
  ''' </summary>
  ''' <param name="dt">DataTable-Objekt</param>
  ''' <returns>Menge von Flugobjekten</returns>
  Public Shared Function MapTable(ByVal dt As System.Data.DataTable) As FlugMenge
   Dim ff As FlugMenge = New FlugMenge()
   For Each dr As System.Data.DataRow In dt.Rows
    Dim f As Flug = Map(dr)
    ff.Add(f)
   Next dr
   Return ff
  End Function
#End Region

  ''' <summary>
  ''' Zhle die Anzahl der Flge in der Datenbank.
  ''' </summary>
  ''' <returns>Gesamtanzahl der Flge</returns>
  Public Function Count() As System.Int32
   Return New DAL.Flug_DataManager().Count()
  End Function

  ''' <summary>
  ''' Zhle die Anzahl der Flge im RAM.
  ''' </summary>
  ''' <returns>Gesamtanzahl der Flge</returns>
  Public Function Count_RAM() As System.Int32
   Return Flug.Fluege.Count
  End Function


  ''' <summary>
  ''' Zhle die Anzahl der Flge fr einen bestimmten Abflugort.
  ''' </summary>
  ''' <returns>Gesamtanzahl der Flge</returns>
  Public Function Count(ByVal Abflugort As String) As System.Int32
   Return New DAL.Flug_DataManager().Count(Abflugort)
  End Function

  ''' <summary>
  ''' Holle alle Flge
  ''' </summary>
  ''' <returns>Mengen von Flgen</returns>
  <System.ComponentModel.DataObjectMethod(System.ComponentModel.DataObjectMethodType.Select)> _
  Public Shared Function HoleAlle() As FlugMenge
   Return MapTable(DAL.Flug_DataManager.AlleFluege_DS().Tables(0))
  End Function

  ''' <summary>
  ''' Holle alle Flge fr einen Abflufhafen
  ''' </summary>
  ''' <returns>Mengen von Flgen</returns>
  <System.ComponentModel.DataObjectMethod(System.ComponentModel.DataObjectMethodType.Select)> _
  Public Shared Function HoleAlle(ByVal FL_Abflughafen As String) As FlugMenge
   Return MapTable(DAL.Flug_DataManager.AlleFluege_DS(FL_Abflughafen).Tables(0))
  End Function

  ''' <summary>
  ''' Holle alle Flge mit SQL 2005 Paging
  ''' </summary>
  ''' <returns>Mengen von Flgen</returns>
  <System.ComponentModel.DataObjectMethod(System.ComponentModel.DataObjectMethodType.Select)> _
  Public Shared Function HoleAlle(ByVal Anzahl As System.Int32, ByVal Start As System.Int32) As FlugMenge
   If Anzahl = -1 Then
    Return HoleAlle()
   End If
   Dim c As System.Int32 = 0
   Dim ff As FlugMenge = New FlugMenge()
   For Each dr As System.Data.DataRow In DAL.Flug_DataManager.AlleFluege_DS(Start, Start + Anzahl).Tables(0).Rows
    Dim f As Flug = Map(dr)
    ff.Add(f)
   Next dr
   Return ff
  End Function

  ''' <summary>
  ''' Holle alle Flge mit SQL 2005 Paging und Sortieren!
  ''' </summary>
  ''' <returns></returns>
  <System.ComponentModel.DataObjectMethod(System.ComponentModel.DataObjectMethodType.Select)> _
  Public Shared Function HoleAlle(ByVal Sortierung As System.String, ByVal Anzahl As System.Int32, ByVal Start As System.Int32) As FlugMenge
   If Anzahl = -1 Then
    Return HoleAlle()
   End If
   Dim c As System.Int32 = 0
   Dim ff As FlugMenge = New FlugMenge()
   For Each dr As System.Data.DataRow In DAL.Flug_DataManager.AlleFluege_DS(Sortierung, Start, Start + Anzahl).Tables(0).Rows
    Dim f As Flug = Map(dr)
    ff.Add(f)
   Next dr
   Return ff
  End Function

  ''' <summary>
  ''' Holle alle Flge mit Filtern, SQL 2005 Paging und Sortieren!
  ''' </summary>
  ''' <returns></returns>
  <System.ComponentModel.DataObjectMethod(System.ComponentModel.DataObjectMethodType.Select)> _
  Public Shared Function HoleAlle(ByVal Abflugort As System.String, ByVal Sortierung As System.String, ByVal Anzahl As System.Int32, ByVal Start As System.Int32) As FlugMenge
   If Anzahl = -1 Then
    Return HoleAlle()
   End If
   Dim c As System.Int32 = 0
   Dim ff As FlugMenge = New FlugMenge()
   For Each dr As System.Data.DataRow In DAL.Flug_DataManager.AlleFluege_DS(Abflugort, Sortierung, Start, Start + Anzahl).Tables(0).Rows
    Dim f As Flug = Map(dr)
    ff.Add(f)
   Next dr
   Return ff
  End Function

  ''' <summary>
  ''' Hole einen Flug
  ''' </summary>
  <System.ComponentModel.DataObjectMethod(System.ComponentModel.DataObjectMethodType.Select)> _
  Public Shared Function HoleFlug(ByVal FlugNr As Long) As de.WWWings.Flug
   Dim dr As System.Data.Common.DbDataReader = New de.WWWings.DAL.Flug_DataManager().GetFlug_DR(FlugNr)
   Dim f As Flug = Map(dr)
   Return f
  End Function

  ''' <summary>
  ''' Speichern eines bereits vorher geladenen Flugs
  ''' </summary>
  ''' <param name="f">Das zu speichernde Flugobjket</param>
  <System.ComponentModel.DataObjectMethod(System.ComponentModel.DataObjectMethodType.Update)> _
  Public Shared Sub SpeichereFlug(ByVal f As Flug)
   ' ggf Konsistenzprfungen
   de.WWWings.DAL.Flug_DataManager.Update(f.AbflugOrt, f.ZielOrt, f.Plaetze, f.FlugNr)
  End Sub

  ''' <summary>
  ''' Lschen eines Flugs
  ''' </summary>
  ''' <param name="f">Flug-Objekt fr den lschenden Flug</param>
  <System.ComponentModel.DataObjectMethod(System.ComponentModel.DataObjectMethodType.Delete)> _
  Public Shared Sub LoescheFlug(ByVal f As Flug)
   de.WWWings.DAL.Flug_DataManager.LoescheFlug(CInt(f.FlugNr))
  End Sub

  ''' <summary>
  ''' Speichern eines bereits vorher geladenen Flugs
  ''' </summary>
  ''' <param name="FL_Abflugort"></param>
  ''' <param name="FL_ZielOrt"></param>
  ''' <param name="FL_Plaetze"></param>
  ''' <param name="FL_NichtRaucherFlug"></param>
  ''' <param name="FL_EingerichtetAm"></param>
  ''' <param name="original_Fl_FlugNr"></param>
  <System.ComponentModel.DataObjectMethod(System.ComponentModel.DataObjectMethodType.Update)> _
  Public Shared Sub SpeichereFlug(ByVal FL_Abflugort As String, ByVal FL_ZielOrt As String, ByVal FL_Plaetze As Long, ByVal FL_NichtRaucherFlug As Boolean, ByVal FL_EingerichtetAm As DateTime, ByVal original_Fl_FlugNr As Integer)
   de.WWWings.DAL.Flug_DataManager.Update(FL_Abflugort, FL_ZielOrt, FL_Plaetze, FL_NichtRaucherFlug, FL_EingerichtetAm, original_Fl_FlugNr)
  End Sub

  Public Function Ping() As Boolean
   Return True
  End Function
 End Class
End Namespace


'/// <summary>
'/// Typischer OR-Mapping-Code
'/// </summary>
'public static Fluege Alle()
'{
' Fluege ff = new Fluege();
' foreach (System.Data.DataRow dr in Fluege.AlleFluege_DS().Tables[0].Rows)
' {
'  Flug f = new Flug(dr);
'  ff.Add(f.FlugNr, f);
' }
' return ff;
'}

''' <summary>
''' Holle alle Flge mit primitivem Paging
''' </summary>
''' <returns></returns>
'public static FlugMenge HoleAlle(System.Int32 maximumRows, System.Int32 startRowIndex)
'{
' System.Int32 c = 0;
' FlugMenge ff = new FlugMenge();
' foreach (System.Data.DataRow dr in Fluege.AlleFluege_DS().Tables[0].Rows)
' {
'  if ((c >= startRowIndex) && (c < startRowIndex + maximumRows))
'  {
'   Flug f = Map(dr);
'   ff.Add(f);
'  }
'  c++;
' }
' return ff;
'}