#Region "Using directives"


Imports Microsoft.VisualBasic
Imports System
Imports System.Collections.Generic
Imports System.Text

#End Region
Imports de.WWWings.PassagierSystem
Imports de.WWWings

Namespace de.WWWings.PassagierSystem

	<System.Serializable()> _
	Public Class Passagier : Inherits de.WWWings.Person

		Public Delegate Sub CheckInStartHandler(ByVal p As Passagier)
		Public Delegate Sub CheckInEndeHandler(ByVal p As Passagier)

		' ========== Klassenmitglieder
		<System.CLSCompliant(False)> _
		Public Shared Passagiere As de.WWWings.PassagierSystem.Passagiere = New Passagiere()
		' ========== Attribute (Fields)
		<System.CLSCompliant(False)> _
		Public Fluege As de.WWWings.Fluege = New de.WWWings.Fluege()
		Public ReadOnly PID As Long
		Private _AktuellerFlug As de.WWWings.Flug
		'  ========== Errechnete Attribute (Properties)
		Public ReadOnly Property AktuellerFlug() As Flug
			Get

				Return Me._AktuellerFlug
			End Get
		End Property
		' =========== Ereignisse
		Public Shared Event CheckInStart As CheckInStartHandler
		Public Shared Event CheckInEnde As CheckInEndeHandler
		' ========== Konstruktoren
  Public Sub New()
  End Sub

		Public Sub New(ByVal Name As String, ByVal Vorname As String)
			MyBase.New(Name, Vorname)
			Me.PID = Passagier.Passagiere.Add(Me)
		End Sub

		Public Sub New(ByVal PID As Long)
			Me.PID = PID
		End Sub
		' ========== Methoden



  ''' <summary>Einchecken eines Passagiers fr einen Flug</summary>
  ''' <param name="Flugnummer">Die Methode erwartet eine Flugnummer</param>
  ''' <returns>Die Methode liefert als Rckgabewert das Flugobjekt, wenn das Einchecken erfolgreich war.</returns>
		Public Function CheckIn(ByVal Flugnummer As Long) As Flug
			If Not CheckInStartEvent Is Nothing Then
				RaiseEvent CheckInStart(Me)
			End If

			If Not(Me.Fluege.ContainsKey(Flugnummer)) Then
				Throw New de.WWWings.PassagierSystem.PassagierNichtAufFlugGebucht(Me.PID & "/" & Flugnummer)
			Else
				If Not CheckInEndeEvent Is Nothing Then
					RaiseEvent CheckInEnde(Me)
				End If
				Return Me.Fluege(Flugnummer)
			End If
		End Function
		Public Overrides Sub Info()
			Console.WriteLine("Passagier: " & Me.GanzerName)
		End Sub


  '''----- Ausimplementiert
  '''

		Private DAL As DAL.Passagier_DataManager = New de.WWWings.DAL.Passagier_DataManager()

  ''' <summary>
  ''' Einzelbuchung
  ''' </summary>
  ''' <param name="Flugnummer"></param>
  ''' <returns></returns>
  Public Function Buchen(ByVal Flugnummer As Long) As Long
   'if (!(Flug.Fluege.ContainsKey(Flugnummer)))
   '{
   ' throw new de.WWWings.PassagierSystem.FalscheFlugnummer(this.PID + "/" + Flugnummer);
   '}
   'else
	'this.Buchen(de.WWWings.Flug.Fluege[Flugnummer]);
	DAL.Buchung(Me.PID, Flugnummer)
	Dim Buchungscode As Long = New Random().Next(100000)
	Return Buchungscode
  End Function

  Public Function Buchen(ByVal flug As de.WWWings.Flug) As Buchung
   Me.Fluege.Add(flug.FlugNr, flug)
   Dim b As Buchung = New Buchung()
   b.Flug = flug
   b.Passagier = Me
   Return b
  End Function

  ''' <summary>
  ''' Mehrfachbuchung (als Transaktion)
  ''' </summary>
  ''' <param name="Flugnummern"></param>
  Public Sub Buchen(ByVal Flugnummern As Long())
   DAL.MehrfachBuchung(Me.PID, Flugnummern)
   'd.Dispose();
  End Sub

  Public Function AlleBuchungenLoeschen() As Long
			Return BuchungLoeschen()
  End Function

		Private Function BuchungLoeschen() As Long
			Dim anz As Long = DAL.AlleBuchungenLoeschen(Me.PID)
			'd.Dispose();
			Return anz
		End Function

  Public Function AlleBuchungen() As System.Data.Common.DbDataReader

   Dim r As System.Data.Common.DbDataReader = DAL.AlleBuchungen(Me.PID)
   'd.Dispose();
   Return r

  End Function
	End Class
End Namespace
