﻿using System;
using System.Collections.Generic;
using System.Text;
using de.ITVisions.DemoViewer;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using de.WWWings.MiscDemos;
namespace NET2.ADONET
{
 [Demo]
 class Command
 {

  /// <summary>
  /// SQL-Befehle in einer Transaktion ausführen
  /// Flüge 313 und 192
  /// </summary>
  public void ADONET_Transaction_Demo()
  {

   Demo.PrintHeader("Command-Transaction-Demo");
   string CONNSTRING = DemoConfig.CONNSTRING;

   const string SQL1 = @"INSERT INTO GF_GebuchteFluege ([GF_PS_ID], [GF_FL_FlugNr], [GF_Preis], [GF_Klasse]) " +
    "VALUES (1, 313, 500, 'F')";
   const string SQL2 = @"INSERT INTO GF_GebuchteFluege ([GF_PS_ID], [GF_FL_FlugNr], [GF_Preis], [GF_Klasse]) " +
    "VALUES (1, 193, 500, 'F')"; // Erfolgreicher Befehl
   //const string SQL2 = @"INSERT INTO GF_GebuchteFluege ([GF_PS_ID], [GF_FL_FlugNr], [GF_FlugDatum], [GF_Preis], [GF_Klasse]) " +
   // "VALUES (1, 203, 8/1/2005, 500, 'FFF')"; // Zum Testen: Fehlerhafter Befehl
   const string SQL3 = "Select count(*) from GF_GebuchteFluege";
   // Verbindung aufbauen
   SqlConnection sqlConn = new SqlConnection(CONNSTRING);
   sqlConn.Open();

   // Befehlsobjekt erzeugen
   SqlCommand sqlCmd = sqlConn.CreateCommand();
   sqlCmd.CommandText = SQL3;
   Demo.Print("Anzahl Datensätze vorher: " + sqlCmd.ExecuteScalar().ToString());
   SqlTransaction t = null;
   try
   {
    t = sqlConn.BeginTransaction();
    sqlCmd.CommandText = SQL1;
    sqlCmd.Transaction = t;
    Demo.Print(SQL1);
    Demo.Print("Betroffene Zeilen: " + sqlCmd.ExecuteNonQuery());
    sqlCmd.CommandText = SQL2;
    sqlCmd.Transaction = t;
    Demo.Print(SQL2);
    Demo.Print("Betroffene Zeilen: " + sqlCmd.ExecuteNonQuery());
    t.Commit();
    Demo.Print("Transaktion erfolgreich ausgeführt!");
   }
   catch (Exception ex)
   {
    t.Rollback();
    Demo.Print("Transaktion fehlgeschlagen: " + ex.Message);
   }
   finally
   {
    sqlCmd.CommandText = SQL3;
    Demo.Print("Anzahl Datensätze nachher: " + sqlCmd.ExecuteScalar().ToString());
    sqlConn.Close();
   }
  }

  // === SQL-Befehle in einer Transaktion ausführen unter Verwendung von Parametern
  public void ADONET_Command_Parameters()
  {

   Demo.PrintHeader("Command-Transaction-Demo mit Parametern");
   string CONNSTRING = DemoConfig.CONNSTRING;

   const string SQL1 = @"INSERT INTO GF_GebuchteFluege ([GF_PS_ID], [GF_FL_FlugNr], [GF_Preis], [GF_Klasse]) " +
    "VALUES (@PS, @FL, @Preis, @Klasse)";
   const string SQL2 = @"INSERT INTO GF_GebuchteFluege ([GF_PS_ID], [GF_FL_FlugNr], [GF_Preis], [GF_Klasse]) " +
    "VALUES (@PS, @FL, @Preis, @Klasse)";
   const string SQL3 = "Select count(*) from GF_GebuchteFluege";
   // Verbindung aufbauen
   SqlConnection sqlConn = new SqlConnection(CONNSTRING);
   sqlConn.Open();

   // Befehlsobjekt erzeugen
   SqlCommand sqlCmd = sqlConn.CreateCommand();
   sqlCmd.CommandText = SQL3;
   Demo.Print("Anzahl Datensätze vorher: " + sqlCmd.ExecuteScalar().ToString());
   SqlTransaction t = null;
   try
   {
    t = sqlConn.BeginTransaction();
    sqlCmd.CommandText = SQL1;
    sqlCmd.Transaction = t;
    sqlCmd.Parameters.AddWithValue("@PS", 1);
    sqlCmd.Parameters.AddWithValue("@FL", 600);
    sqlCmd.Parameters.AddWithValue("@Preis", 300);
    sqlCmd.Parameters.AddWithValue("@Klasse", "F");

    Demo.Print(SQL1);
    Demo.Print("Betroffene Zeilen: " + sqlCmd.ExecuteNonQuery());
    sqlCmd.CommandText = SQL2;
    sqlCmd.Transaction = t;

    sqlCmd.Parameters["@FL"].Value = 601;
    sqlCmd.Parameters["@Preis"].Value = 240;
 
    Demo.Print(SQL2);
    Demo.Print("Betroffene Zeilen: " + sqlCmd.ExecuteNonQuery());
    t.Commit();
    Demo.Print("Transaktion erfolgreich ausgeführt!");
   }
   catch (Exception ex)
   {
    t.Rollback();
    Demo.Print("Transaktion fehlgeschlagen: " + ex.Message);
   }
   finally
   {
    sqlCmd.CommandText = SQL3;
    Demo.Print("Anzahl Datensätze nachher: " + sqlCmd.ExecuteScalar().ToString());
    sqlConn.Close();
   }
  }
 }
}
