﻿using System;
using System.Collections.Generic;
using System.Text;
using de.ITVisions.DemoViewer;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using de.WWWings.MiscDemos;
namespace NET2.ADONET
{
 [Demo]
 class DataSetDemos
 {

  // Einlesen einer XML-Datei in einen DataSet
  public void DataSet_LesenAusXmlDatei()
  {
   DataSet ds = new DataSet();

   ds.ReadXml(@"c:\websites.xml");

   Demo.Print(ds.GetXmlSchema());


   foreach (DataTable dt in ds.Tables)
   {
    Demo.Print("Tabelle: " + dt.TableName + "\n-------\n");
    foreach (DataRow dr in dt.Rows)
    {
     //string?[] s = dr.ItemArray as string?[];
     //Demo.Print(String.Join(";", s));
     foreach (DataColumn dc in dt.Columns)
     {
      Demo.Print((dr[dc.ColumnName] ?? "n/a").ToString());
     }
    }

    foreach (DataRelation drel in ds.Relations)
    {
     Demo.Print(drel.RelationName);
    }

    foreach (DataRow dr in ds.Tables["Website"].Rows)
    {
     Demo.Print(dr["URL"].ToString());

     foreach (DataRow dr2 in dr.GetChildRows("Website_Zugangsdaten"))
     {
      //foreach (DataRow dr3 in dr2.GetChildRows("Inhaber_Name"))
      //{
      // 

      Demo.Print(" - Name: " + dr2[0].ToString());
      //}
     }

    }

   }


  }

  // === Daten lesen mit einem DataSet
  public void DataSet_Lesen()
  {
   Demo.PrintHeader("Datareader Demo");

   string CONNSTRING = DemoConfig.CONNSTRING;
   const string SQL = "Select * from FL_Fluege";

   // --- Verbindung aufbauen
   SqlConnection conn = new SqlConnection(CONNSTRING);
   conn.Open();
   // --- Befehl ausführen
   SqlCommand cmd = new SqlCommand(SQL, conn);
   // --- Datenadapter erzeugen
   SqlDataAdapter da = new SqlDataAdapter(cmd);
   // --- DataSet erzeugen
   DataSet ds = new DataSet();
   // --- Daten abholen
   da.Fill(ds, "Flug");
   // --- Verbindung jetzt schon schließen!
   conn.Close();
   // --- Zugriff auf die einzige Tabelle
   DataTable dt = ds.Tables["Flug"];
   Demo.Print("Name der Tabelle: " + dt.TableName);
   // --- Iteration über Daten
   foreach (DataRow dr in dt.Rows)
   {
    Demo.Print("Flug-ID: " + dr["FL_FlugNr"] + " von " + dr[1] + " nach " + dr[2] );
   }
   
   Demo.Print(ds.GetXmlSchema());
   Demo.Print(ds.GetXml());
   ds.WriteXml(@"c:\Fluege.xml", XmlWriteMode.WriteSchema);

   // Datensicht definieren
   Demo.PrintHeader("Selektierte Daten:");
   DataView dv = new DataView(dt);
   dv.RowFilter = "FL_Abflugort = 'Paris'";
   dv.Sort = "FL_Zielort desc";
   // --- Iteration über Daten
   foreach (DataRowView drv in dv)
   {
    DataRow dr = drv.Row;
    Demo.Print("Flug-ID: " + dr["FL_FlugNr"] + " von " + dr[1] + " nach " + dr[2] );
   }
  }

  // === Daten verknüpfen in einem DataSet
  public void Dataset_Beziehungen()
  {
   Demo.PrintHeader("Passagiere mit Ihren Flügen (Dataset-Beziehungen-Demo)");

   string CONNSTRING = DemoConfig.CONNSTRING;
   const string SQL1 = "Select * from AllePassagiere";
   const string SQL2 = "Select * from GF_GebuchteFluege";

   // --- Verbindung aufbauen
   SqlConnection conn = new SqlConnection(CONNSTRING);
   conn.Open();
   // --- Leeres DataSet erzeugen
   DataSet ds = new DataSet();
   // --- Datenadapter erzeugen
   SqlDataAdapter da1 = new SqlDataAdapter(SQL1, CONNSTRING);
   SqlDataAdapter da2 = new SqlDataAdapter(SQL2, CONNSTRING);
   // --- Daten abholen
   da1.Fill(ds, "AllePassagiere");
   da2.Fill(ds, "GebuchteFluege");
   // --- Verbindung jetzt schon schließen!
   conn.Close();
   // --- Verknpüfung herstellen
   DataColumn dc1 = ds.Tables["AllePassagiere"].Columns["PS_ID"];
   DataColumn dc2 = ds.Tables["GebuchteFluege"].Columns["GF_PS_ID"];
   DataRelation drel = new DataRelation("Passagiere_GebuchteFluege", dc1, dc2);
   ds.Relations.Add(drel);

   // --- Zugriff auf Tabelle Websites
   DataTable dt = ds.Tables["AllePassagiere"];
   // --- Iteration über Daten
   foreach (DataRow dr in dt.Rows)
   {
    Demo.Print("Name: " + dr["PE_Name"] + " Vorname: " + dr["PE_Vorname"]);
    foreach (DataRow dr2 in dr.GetChildRows(drel))
    {
     Demo.Print("  Flug: " + dr2["GF_FL_FlugNr"] + " Preis: " + dr2["GF_Preis"] );
    }
   }
  }
 }
}
