using System;
using System.IO;
using de.ITVisions.DemoViewer;

namespace NET2.FCL
{

 [Demo]
 public class Dateiinhalte
 {

  // Schreiben einer Protokolldatei
  public void Textdatei_Schreiben()
  {
   // Festlegung der Datei
   string dateiName = @"..\..\_daten\dateisystem\protokolldatei.txt";
   // Datei ffnen
   FileStream fs = new FileStream(dateiName, FileMode.OpenOrCreate, FileAccess.Write);
   // Stream ffnen
   StreamWriter w = new StreamWriter(fs);
   // Anfgen am Ende
   w.BaseStream.Seek(0, SeekOrigin.End);
   // Zeilen Schreiben
   w.WriteLine("Start des Programms: " + DateTime.Now.ToString());
   // Zeichen schreiben ohne Umbruch
   w.Write("Datenblock: ");
   for (int i = 0; i < 26; i++)
    w.Write((char)(97 + i));
   // Zeilen Schreiben
   w.WriteLine();
   w.WriteLine("Ende des Programms: " + DateTime.Now.ToString());
   // Writer und Stream schlieen
   w.Close();
  
   fs.Close();
  }

  // Lesen aus einer Protokolldatei
  public void Textdatei_Lesen()
  {
   // Festlegung der Datei
   string dateiName = @"..\..\_daten\dateisystem\protokolldatei.txt";
   // Datei ffnen
   FileStream fs = new FileStream(dateiName, FileMode.OpenOrCreate, FileAccess.ReadWrite);

   // Stream ffnen
   StreamReader r = new StreamReader(fs);
   // Zeiger auf den Anfang
   r.BaseStream.Seek(0, SeekOrigin.Begin);
   // Alle Zeilen lesen und zeilenweise ausgeben
   while (r.Peek() > -1)
    Demo.Print(r.ReadLine());
   // Reader und Stream schliessen
   r.Close();
 
   fs.Close();
  }

  public void BinaerDatei_Schreiben()
  {
   // Schreiben einer Binrdatei
   string dateiName = @"..\..\_daten\dateisystem\daten.bin";
   // Datei ffnen
   FileStream fs = new FileStream(dateiName, FileMode.OpenOrCreate, FileAccess.Write);
   // Stream ffnen
   BinaryWriter w = new BinaryWriter(fs);
   // Anfgen am Ende
   w.BaseStream.Seek(0, SeekOrigin.End);
   // Einzelne Zeichen schreiben
   for (int i = 0; i < 255; i++)
    w.Write(i + 1);
   // Stream schlieen
   w.Close();
   fs.Close();
   Demo.Print("Daten in Protokoll geschrieben!");
  }

  public void BinaerDatei_Lesen()
  {
   // Zeichenweise binres Lesen aus einer Datei
   string dateiName = @"..\..\_daten\dateisystem\daten.bin";
   // Datei ffnen
   FileStream fs = new FileStream(dateiName, FileMode.OpenOrCreate, FileAccess.ReadWrite);
   // Stream ffnen
   BinaryReader r = new BinaryReader(fs);
   // Zeiger auf den Anfang
   r.BaseStream.Seek(0, SeekOrigin.Begin);
   // Alle Zeilen lesen und ausgeben
   string ausgabe = String.Empty;
   while (r.PeekChar() > -1)
   {
    if (ausgabe != "")
     ausgabe += ",";
    ausgabe += r.ReadByte();
   }
   Demo.Print(ausgabe);
   r.Close();
  }
 }
}
