﻿#region Using directives

using System;
using System.Collections.Generic;
using System.Text;

#endregion
using System.Net.NetworkInformation;
using System.Net;
using System.Threading;
using de.ITVisions.DemoViewer;
using System.IO;

namespace NET2.FCL
{
 [de.ITVisions.DemoViewer.Demo]
 public class Netzwerk
 {

  //[Demo("Herunterladen einer Datei per FTP")]
  public void FTPDownload()
  {
   const string URL = @"ftp://bochum/Flugdaten.xml";
   const string LOKALERPFAD = @"c:\temp\Flugdaten_download.xml";
   FtpWebRequest ftp = (FtpWebRequest)FtpWebRequest.Create(URL);
   ftp.Method = WebRequestMethods.Ftp.DownloadFile;
   ftp.Credentials = new NetworkCredential("xx", "xxx");
   FtpWebResponse response = (FtpWebResponse)ftp.GetResponse();
   Stream responseStream = response.GetResponseStream();
   Demo.Print("Lade Datei...");
   FileStream fileStream = null;

   // Öffnen der Zieldatei
   fileStream = File.Create(LOKALERPFAD);
   byte[] buffer = new byte[1024];
   int bytesRead;
   // Einlesen und in Datei kopieren
   while (true)
   {
    bytesRead = responseStream.Read(buffer, 0, buffer.Length);
    if (bytesRead == 0)
     break;
    fileStream.Write(buffer, 0, bytesRead);
    Console.Write(".");
   }
   // Alles schliessen!
   responseStream.Close();
   fileStream.Close();
   Demo.Print("Fertig!");
  }

  //[Demo("Heraufladen einer Datei per FTP")]
  [FCL2]
  public void FTPUpload()
  {
   const string URL = @"ftp://bochum/Flugdaten.xml";
   const string LOKALERPFAD = @"c:\temp\Flugdaten.xml";

   // --- Request erstellen
   FtpWebRequest ftp = (FtpWebRequest)WebRequest.Create(URL);
   ftp.Method = WebRequestMethods.Ftp.UploadFile;
   ftp.Credentials = new NetworkCredential("xx", "xxx");
   ftp.Timeout = System.Threading.Timeout.Infinite;
   Stream requestStream = ftp.GetRequestStream();
   Demo.Print("Sende Datei...");
   // --- Kopieren des Inhalts aus der Datei
   const int bufferLength = 2048;
   byte[] buffer = new byte[bufferLength];
   int count = 0;
   int readBytes = 0;
   // Öffnen der Quelldatei
   FileStream fileStream = File.OpenRead(LOKALERPFAD);
   // Einlesen der Quelldatei
   do
   {
    readBytes = fileStream.Read(buffer, 0, bufferLength);
    requestStream.Write(buffer, 0, bufferLength);
    count += readBytes;
    Console.Write(".");
   }
   while (readBytes != 0);
   // --- Antworten holen
   requestStream.Close();
   FtpWebResponse response = (FtpWebResponse)ftp.GetResponse();
   Demo.Print("Fertig!");
   response.Close();
   fileStream.Close();
  }

  //[Demo("Inhalt eines FTP-Verzeichnisses auflisten")]
  [FCL2]
  public void FTPInhaltAuflisten()
  {
   const string URL = @"ftp://bochum/";
   StreamReader reader = null;
   FtpWebRequest ftp =
       (FtpWebRequest)WebRequest.Create(URL);
   ftp.Credentials = new NetworkCredential("ar", "hs");
   ftp.Method = WebRequestMethods.Ftp.ListDirectoryDetails;
   FtpWebResponse Response =
       (FtpWebResponse)ftp.GetResponse();
   reader = new StreamReader(Response.GetResponseStream());
   Demo.Print(reader.ReadToEnd());
   Demo.Print("Fertig!");
   reader.Close();
  }


  // Ping ausführen
  public void Ping()
  {
   const string COMPUTER = "www.IT-Visions.de";
   Ping p = new Ping();
   // Ping synchron ausführen
   Demo.PrintHeader("Synchroner Ping");
   PingReply pr = p.Send(COMPUTER);
   Demo.Print(pr.Status + ";" + pr.RoundtripTime);
   // Ping asynchron ausführen
   Demo.PrintHeader("Asynchroner Ping");
   p.PingCompleted += new PingCompletedEventHandler(p_PingCompleted);
   p.SendAsync(COMPUTER, null);

  }
  // Callsback für Ping
  static void p_PingCompleted(object sender, PingCompletedEventArgs e)
  {
   Demo.Print(e.Reply.Status + ";" + e.Reply.RoundtripTime + "ms");
  }

  public void NetStatus()
  {
   NetworkInterface[] adapters = NetworkInterface.GetAllNetworkInterfaces();
   foreach (NetworkInterface n in adapters)
   {
    Demo.Print("Netzwerkstatus:  {0} = {1}", n.Name, n.OperationalStatus);
   }
  }
  public void NetStatusWarten()
  {
   NetStatus();
   NetworkChange.NetworkAvailabilityChanged += new NetworkAvailabilityChangedEventHandler(NetworkChange_NetworkAvailabilityChanged);
   Demo.Print("Überwachung...");
   Console.ReadLine();
  }

  void NetworkChange_NetworkAvailabilityChanged(object sender, NetworkAvailabilityEventArgs e)
  {
   NetStatus();
  }


  // Statistische Daten aus dem TCP/IP-Protokollstack
  public void NetStatistik()
  {
   IPGlobalProperties ipgp = IPGlobalProperties.GetIPGlobalProperties();
   TcpStatistics t = ipgp.GetTcpIPv4Statistics();
   Demo.Print("CurrentConnections: " + t.CurrentConnections.ToString());
   Demo.Print("ErrorsReceived: " + t.ErrorsReceived.ToString());
   Demo.Print("MaximumConnections: " + t.MaximumConnections.ToString());
   Demo.Print("SegmentsReceived: " + t.SegmentsReceived.ToString());
   Demo.Print("SegmentsSent: " + t.SegmentsSent.ToString());
  }

  // Absenden einer HTTP-Anfrage
  public void HTTP_Anfrage()
  {
   const string URL = "http://www.it-visions.de";
   // Anfrage definieren
   HttpWebRequest frage = (HttpWebRequest)HttpWebRequest.Create(URL);
   // Antwort holen
   HttpWebResponse antwort = (HttpWebResponse)frage.GetResponse();
   // Meta-Daten
   Demo.Print("Antwortlänge: " + antwort.ContentLength);
   Demo.Print("Status: " + antwort.StatusCode);
   Demo.Print("Letzte Änderung: " + antwort.LastModified);
   Demo.Print("Inhaltstyp: " + antwort.ContentType);
   // Inhalt ausgeben
   StreamReader sr = new StreamReader(antwort.GetResponseStream());
   Demo.Print(sr.ReadToEnd());
  }

  // FTP Download
  public static bool DisplayFileFromServer()
  {

   Uri serverUri = new Uri(@"ftp://bochum");
   // The serverUri parameter should start with the ftp:// scheme.
   if (serverUri.Scheme != Uri.UriSchemeFtp)
   {
    return false;
   }
   // Get the object used to communicate with the server.
   WebClient request = new WebClient();

   // This example assumes the FTP site uses anonymous logon.
   request.Credentials = new NetworkCredential("xy", "xy");
   try
   {
    byte[] newFileData = request.DownloadData(serverUri.ToString());
    string fileString = System.Text.Encoding.UTF8.GetString(newFileData);
    Demo.Print(fileString);
   }
   catch (WebException e)
   {
    Demo.Print(e.ToString());
   }
   return true;
  }

 }


 public class FtpState
 {
  private ManualResetEvent wait;
  private FtpWebRequest request;
  private string fileName;
  private Exception operationException = null;
  string status;

  public FtpState()
  {
   wait = new ManualResetEvent(false);
  }

  public ManualResetEvent OperationComplete
  {
   get { return wait; }
  }

  public FtpWebRequest Request
  {
   get { return request; }
   set { request = value; }
  }

  public string FileName
  {
   get { return fileName; }
   set { fileName = value; }
  }
  public Exception OperationException
  {
   get { return operationException; }
   set { operationException = value; }
  }
  public string StatusDescription
  {
   get { return status; }
   set { status = value; }
  }
 }

 [Demo]
 public class AsynchronousFtpUpLoader
 {
  // Command line arguments are two strings:
  // 1. The url that is the name of the file being uploaded to the server.
  // 2. The name of the file on the local machine.
  //
  public void Start()
  {
   // Create a Uri instance with the specified URI string.
   // If the URI is not correctly formed, the Uri constructor
   // will throw an exception.
   ManualResetEvent waitObject;

   Uri target = new Uri(@"ftp://ff44.s6.domainkunden.de/~db/extranet.mdb");
   string fileName = @"M:\ITVWEB\~db\extranet.mdb";
   FtpState state = new FtpState();
   FtpWebRequest request = (FtpWebRequest)WebRequest.Create(target);
   //request.Method = FtpMethods.UploadFile;

   // This example uses anonymous logon.
   // The request is anonymous by default; the credential does not have to be specified. 
   // The example specifies the credential only to
   // control how actions are logged on the server.

   request.Credentials = new NetworkCredential("FF44", "xb3472868");

   // Store the request in the object that we pass into the
   // asynchronous operations.
   state.Request = request;
   state.FileName = fileName;

   // Get the event to wait on.
   waitObject = state.OperationComplete;

   // Asynchronously get the stream for the file contents.
   request.BeginGetRequestStream(
       new AsyncCallback(EndGetStreamCallback),
       state
   );

   // Block the current thread until all operations are complete.
   waitObject.WaitOne();

   // The operations either completed or threw an exception.
   if (state.OperationException != null)
   {
    throw state.OperationException;
   }
   else
   {
    Demo.Print("The operation completed - {0}", state.StatusDescription);
   }
  }
  private static void EndGetStreamCallback(IAsyncResult ar)
  {
   FtpState state = (FtpState)ar.AsyncState;

   Stream requestStream = null;
   // End the asynchronous call to get the request stream.
   try
   {
    requestStream = state.Request.EndGetRequestStream(ar);
    // Copy the file contents to the request stream.
    const int bufferLength = 2048;
    byte[] buffer = new byte[bufferLength];
    int count = 0;
    int readBytes = 0;
    FileStream stream = File.OpenRead(state.FileName);
    do
    {
     readBytes = stream.Read(buffer, 0, bufferLength);
     requestStream.Write(buffer, 0, bufferLength);
     count += readBytes;
    }
    while (readBytes != 0);
    Demo.Print("Writing {0} bytes to the stream.", count);
    // IMPORTANT: Close the request stream before sending the request.
    requestStream.Close();
    // Asynchronously get the response to the upload request.
    state.Request.BeginGetResponse(
        new AsyncCallback(EndGetResponseCallback),
        state
    );
   }
   // Return exceptions to the main application thread.
   catch (Exception e)
   {
    Demo.Print("Could not get the request stream.");
    state.OperationException = e;
    state.OperationComplete.Set();
    return;
   }

  }

  // The EndGetResponseCallback method  
  // completes a call to BeginGetResponse.
  private static void EndGetResponseCallback(IAsyncResult ar)
  {
   FtpState state = (FtpState)ar.AsyncState;
   FtpWebResponse response = null;
   try
   {
    response = (FtpWebResponse)state.Request.EndGetResponse(ar);
    response.Close();
    state.StatusDescription = response.StatusDescription;
    // Signal the main application thread that 
    // the operation is complete.
    state.OperationComplete.Set();
   }
   // Return exceptions to the main application thread.
   catch (Exception e)
   {
    Demo.Print("Error getting response.");
    state.OperationException = e;
    state.OperationComplete.Set();
   }
  }
 }
}



