using System;
using System.Diagnostics;
using de.ITVisions.DemoViewer;

namespace NET2.FCL
{

 [Demo]
 public class Prozesse
 {


  // Liste aller laufenden Prozesse

  public void Prozesse_Liste()
  {

   // Liste der Prozesse holen
   Process[] pp = Process.GetProcesses();

   // Schleife ber alle Prozesse
   foreach (Process p in pp)
   {
    Demo.Print("------------------------");
    Demo.Print(p.Id + ":" + p.ProcessName);
    Demo.Print("------------------------");
    if (p.Id != 0)
    { // Ausnahme fr "Idle" (ID=0) !
     Demo.Print("Handle Count           :" + p.HandleCount.ToString());
     Demo.Print("Main Window Title      :" + p.MainWindowTitle);
     Demo.Print("Min Working Set        :" + p.MinWorkingSet.ToString());
     Demo.Print("Max Working Set        :" + p.MaxWorkingSet.ToString());
     Demo.Print("Paged Memory Size      :" + p.PagedMemorySize64.ToString());
     Demo.Print("Peak Paged Memory Size :" + p.PeakPagedMemorySize64.ToString());
    }

   }
  }

  // Liste aller Instanzen von Microsoft Word
  public void Prozesse_AuflistenSelektiv()
  {
   // Liste ausgewhlter Prozesse
   string processName = "winword";
   // Liste der Prozesse holen
   Process[] pp = Process.GetProcessesByName(processName);
   // Ausgaben
   Demo.Print("Prozesse mit Namen: " + processName);
   Demo.Print("Anzahl von Prozessen: " + pp.Length);
   // Schleife ber alle Instanzen
   foreach (Process p in pp)
    Demo.Print(p.Id + ":" + p.StartTime);
  }

  public void Prozesse_ThreadListe()
  {

   // Liste aller Prozesse mit ihren Threads
   // Liste der Prozesse holen
   Process[] pp = Process.GetProcesses();

   // Schleife ber alle Prozesse
   foreach (Process p in pp)
   {
    Demo.Print("------------------------");
    Demo.Print(p.Id + ":" + p.ProcessName);
    Demo.Print("------------------------");
    if (p.Id != 0)
    { // Ausnahme fr "Idle"(PID=0)!
     // Schleife ber alle Threads
     Demo.Print("Anzahl Threads: " + p.Threads.Count);
     foreach (ProcessThread t in p.Threads)
      Demo.Print("- " + t.Id + ":" + t.ThreadState + ":" + t.StartTime);
    }
   }
  }

  public void Prozesse_ModulListe()
  {

   // Liste aller Prozesse mit ihren Modulen
   // Liste der Prozesse holen
   Process[] pp = Process.GetProcesses();

   // Schleife ber alle Prozesse
   foreach (Process p in pp)
   {

    Demo.Print("------------------------");
    Demo.Print(p.Id + ":" + p.ProcessName);
    Demo.Print("------------------------");

    if (p.Id != 0)
    { // Ausnahme fr "Idle" (ID=0)
     Demo.Print("Anzahl Module: " + p.Modules.Count);

     if (p.MainModule != null)
      Demo.Print("Hauptmodul: " + p.MainModule.ModuleName);

     // Schleife ber alle Module
     foreach (ProcessModule m in p.Modules)
      Demo.Print("- " + m.ModuleName + ":" + m.FileName + ":" + m.ModuleMemorySize);
    }
   }
  }


  // Start eines Prozesses
  public void Prozess_Starten()
  {
   Process.Start("IExplore.exe", "http://www.dotnetframework.de");
  }

  


  // Alle Internet Explorer-Prozesse stoppen
  public void Prozess_Stoppen()
  {
   string processName = "winword";
   // Prozesse dieses Namens ermitteln
   Process[] pp = Process.GetProcessesByName(processName);
   // Schleife ber diese Prozesse
   Demo.Print("Beenden aller Prozesse mit Namen: " + processName);
   Demo.Print("Anzahl Prozesse: " + pp.Length);
   foreach (Process p in pp)
   {
    Demo.Print("Prozess: " + p.Id + " wird beendet...");
    // Beenden Anfrage stellen...
    if (p.CloseMainWindow())
    {
     // Normales Ende
     Demo.Print("  Prozess wurde normal beendet!");
    }
    else
    {
     // Keine Reaktion -> gewaltsames Ende
     p.Kill();
     Demo.Print("  Prozess wurde gewaltsam beendet!");
    }
   }
  }

  public void Prozesse_ohne_Reaktion_stoppen()
  {

   // Alle hngenden Prozesse stoppen

   // Prozesse ermitteln
   Process[] pp = Process.GetProcesses();

   // Schleife ber diese Prozesse
   Demo.Print("Beenden aller nicht-reagierenden Prozesse");

   foreach (Process p in pp)
   {
    if (!p.Responding)
    {
     Demo.Print("Prozess hngt " + p.ProcessName + " und wird beendet...");
     // Keine Reaktion -> gewaltsames Ende
     p.Kill();
     Demo.Print("  Prozess wurde gewaltsam beendet!");
    }
   }
  }
 }
}
