using System;
using System.Collections.Generic;
using System.Text;
using de.ITVisions.DemoViewer;

namespace VerschiedeneDemos_CS.FCL3
{
 [Demo]
 class FCLSerialiasierung_Objektmodell
 {
  // === Beispiele fr Binres und XML serialisieren
  public void OModell_Serialisieren()
  {

   // --- Objektmodell aufbauen
   Buchautor a = new Buchautor("Holger Schwichtenberg");
   a.Geb = DateTime.Parse("8/1/1972");

   Verlag v = new Verlag();
   v.Name = "Addison Wesley";

   Buch b1 = new Buch("Windows Scripting");

   b1.Auflagen.Add(new Auflage(1, 2000, "3-8273-1637-5"));
   b1.Auflagen.Add(new Auflage(2, 2001, "3-8273-1843-2"));
   b1.Auflagen.Add(new Auflage(3, 2002, "3-8273-2061-5"));
   b1.Verlag = v;

   Buch b2 = new Buch("ASP.NET - Das Entwicklerbuch");

   b2.Auflagen.Add(new Auflage(1, 2002, "3-86063-667-7"));
   b2.Verlag = new Verlag("MSPress");

   Buch b3 = new Buch("Programmieren mit der .NET-Klassenbibliothek");
   b3.Auflagen.Add(new Auflage(1, 2002, "3-8273-1905-6"));
   b3.Verlag = v;

   a.buecher.Add(b2);
   a.buecher.Add(b1);
   a.buecher.Add(b3);

   // --- Variante: zweifacher Verweis auf ein Objekt
   //a.b1 = b1
   //a.b2 = b1

   // --- Objektmodell ausgeben
   autorinfo(a);

   object o = null; // Objekt fr Deserialisierung

   // --- Serialisierungsziele
   const string DATEI = "..\\..\\_daten\\Serial\\buch.bin";
   const string DATEISOAP = "..\\..\\_daten\\Serial\\buch.soap.xml";
   const string DATEIXML = "..\\..\\_daten\\Serial\\buch.xml";
   const string DATEIDATACONTRACT = "..\\..\\_daten\\Serial\\buch.dc.xml";
   const string DATEINETDATACONTRACT = "..\\..\\_daten\\Serial\\buch.ndc.xml";

   // --- binre Serialisieren
   Demo.PrintHeader("Binre Serialisierung...");
  Serialisieren_Hilfsroutinen.save(SerialTyp.BINARY, a, DATEI);
  o = Serialisieren_Hilfsroutinen.load(SerialTyp.BINARY, DATEI);
   autorinfo(o);

   // --- binre Serialisieren
   Demo.PrintHeader("Binre Serialisierung...");
   Serialisieren_Hilfsroutinen.save(SerialTyp.SOAP, a, DATEISOAP);
   o = Serialisieren_Hilfsroutinen.load(SerialTyp.SOAP, DATEISOAP);
   autorinfo(o);

   // --- XML-Serialisieren
   Demo.PrintHeader("XML Serialisierung...");
   Serialisieren_Hilfsroutinen.save(SerialTyp.XML, a, DATEIXML);
   o = Serialisieren_Hilfsroutinen.load(SerialTyp.XML, DATEIXML, typeof(Buchautor));
   autorinfo(o);


   // --- Datacontract-Serialisieren
   Demo.PrintHeader("Datacontract Serialisierung...");
   Serialisieren_Hilfsroutinen.save(SerialTyp.DATACONTRACT, a, DATEIDATACONTRACT);
   o = Serialisieren_Hilfsroutinen.load(SerialTyp.DATACONTRACT, DATEIDATACONTRACT, typeof(Buchautor));
   autorinfo(o);


   // --- Datacontract-Serialisieren
   Demo.PrintHeader("NetDatacontract Serialisierung...");
   Serialisieren_Hilfsroutinen.save(SerialTyp.NETDATACONTRACT, a, DATEINETDATACONTRACT);
   o = Serialisieren_Hilfsroutinen.load(SerialTyp.NETDATACONTRACT, DATEINETDATACONTRACT, typeof(Buchautor));
   autorinfo(o);

   // --- Anlegen einer zirkulren Referenz
   b1.Autor = a;
   b2.Autor = a;
   b3.Autor = a;

   // --- binre Serialisieren
   Demo.PrintHeader("Binre Serialisierung mit zirkulrer Referenz...");
   Serialisieren_Hilfsroutinen.save(SerialTyp.BINARY, a, DATEI);
   // --- Deserialisieren
   a = (Buchautor) Serialisieren_Hilfsroutinen.load(SerialTyp.BINARY, DATEI);
   autorinfo(a);

   // --- binre Serialisieren
   Demo.PrintHeader("SOAP Serialisierung  mit zirkulrer Referenz...");
   Serialisieren_Hilfsroutinen.save(SerialTyp.SOAP, a, DATEISOAP);
   // --- Deserialisieren
   a = (Buchautor)Serialisieren_Hilfsroutinen.load(SerialTyp.BINARY, DATEI);
   autorinfo(a);

   ////' --- XML-Serialisieren
   //Demo.PrintHeader("XML Serialisierung  mit zirkulrer Referenz...");
   //try
   //{
   // Serialisieren_Hilfsroutinen.save(SerialTyp.XML, a, DATEIXML);
   // a = (Buchautor)Serialisieren_Hilfsroutinen.load(SerialTyp.XML, DATEIXML, typeof(Autor));
   // autorinfo(a);
   //}
   //catch (Exception e)
   //{
   // Demo.PrintError("Serialisierung nicht mglich: " + e.Message);
   //}

   // --- Datacontract-Serialisieren
   Demo.PrintHeader("Datacontract Serialisierung...");
   try
   {
    Serialisieren_Hilfsroutinen.save(SerialTyp.DATACONTRACT, a, DATEIDATACONTRACT);
    o = Serialisieren_Hilfsroutinen.load(SerialTyp.DATACONTRACT, DATEIDATACONTRACT, typeof(Buchautor));
    autorinfo(o);
   }
   catch (Exception e)
   {
    Demo.PrintError("Serialisierung nicht mglich: " + e.Message);
   }

   // --- Datacontract-Serialisieren
   Demo.PrintHeader("NetDatacontract Serialisierung...");
   try
   {
    Serialisieren_Hilfsroutinen.save(SerialTyp.NETDATACONTRACT, a, DATEINETDATACONTRACT);
    o = Serialisieren_Hilfsroutinen.load(SerialTyp.NETDATACONTRACT, DATEINETDATACONTRACT, typeof(Buchautor));
    autorinfo(o);
   }
   catch (Exception e)
   {
    Demo.PrintError("Serialisierung nicht mglich: " + e.Message);
   }

  }

  // === Ausgabe des Objektmodell
  public static void autorinfo(object o)
  {
   Buchautor a = (Buchautor)o;
   //INSTANT C# NOTE: Commented this declaration since looping variables in 'foreach' loops are declared in the 'foreach' header in C#
   //  Buch b = null;
   Demo.Print("Autor: " + a.Name + ", " + a.buecher.Count + " Bcher");
   foreach (Buch b in a.buecher)
   {
    Demo.Print("Buch: " + b.Titel);
    if (b.Autor != null)
     Demo.Print("von " + b.Autor.Name);
   }
  }

 }
}
