using System.Runtime.Serialization.Formatters.Binary;
using System.Xml.Serialization;
using System.IO;
using de.ITVisions.DemoViewer;
using System;
namespace VerschiedeneDemos_CS.FCL3
{
 [Demo]
 class FCLSerialsiierung_EinObjekt
 {


 // === Beispiel fr  Serialisieren
 public void Serialisieren_Test()
 {
  // --- Objekt erzeugen und fllen

  Autor a = new Autor();

  a.Name = "Holger Schwichtenberg";
  a.Geb = DateTime.Parse("8/1/1972");
  a.Geschlecht = 'm';
  a.Schwerpunkte = new string[] {"Scripting", "COM", ".NET"};

  // --- Serialisierungsziele
  const string DATEI = "..\\_daten\\Serial\\Autor.bin";
  const string DATEISOAP = "..\\_daten\\Serial\\Autor.soap.xml";
  const string DATEIXML = "..\\_daten\\Serial\\Autor.xml";

  // --- binre Serialisieren
  Demo.Print("-- Binre Serialisierung...");
  Serialisieren_Hilfsroutinen.save(SerialTyp.BINARY, a, DATEI);
  a = (Autor) Serialisieren_Hilfsroutinen.load(SerialTyp.BINARY, DATEI);
  Demo.Print(a.Name + " wurde am " + a.Geb + " geboren!");

  // --- binre Serialisieren
  Demo.Print("-- Binre Serialisierung...");
  Serialisieren_Hilfsroutinen.save(SerialTyp.SOAP, a, DATEISOAP);
  a = (Autor) Serialisieren_Hilfsroutinen.load(SerialTyp.SOAP, DATEISOAP);
  Demo.Print(a.Name + " wurde am " + a.Geb + " geboren!");

  // --- XML Serialisieren
  Demo.Print("-- XML Serialisierung...");
  Serialisieren_Hilfsroutinen.save(SerialTyp.XML, a, DATEIXML);
  a = (Autor) Serialisieren_Hilfsroutinen.load(SerialTyp.XML, DATEIXML, a.GetType());
  Demo.Print(a.Name + " wurde am " + a.Geb + " geboren!");


 }

 // === Beispiel fr  Serialisieren
 public void Deserialisieren_Test()
 {

  // --- Objektvariable bereitstellen
  Autor a1 = null;
  Autor a2 = null;
  Autor a3 = null;

  // --- Serialisierungsziele
  const string DATEI = "..\\_daten\\Serial\\Autor.bin";
  const string DATEISOAP = "..\\_daten\\Serial\\Autor.soap.xml";
  const string DATEIXML = "..\\_daten\\Serial\\Autor.xml";

  // --- binre Serialisieren
  Demo.Print("-- Binre Deserialisierung...");
  a1 = (Autor) Serialisieren_Hilfsroutinen.load(SerialTyp.BINARY, DATEI);
  Demo.Print(a1.Name + " wurde am " + a1.Geb + " geboren!");

  // --- binre Serialisieren
  Demo.Print("-- Binre Deserialisierung...");
  a2 = (Autor) Serialisieren_Hilfsroutinen.load(SerialTyp.SOAP, DATEISOAP);
  Demo.Print(a2.Name + " wurde am " + a2.Geb + " geboren!");

  // --- XML Serialisieren
  Demo.Print("-- XML Deserialisierung...");
  a3 = (Autor) Serialisieren_Hilfsroutinen.load(SerialTyp.XML, DATEIXML, a3.GetType());
  Demo.Print(a3.Name + " wurde am " + a3.Geb + " geboren!");

 }

 // === Beispiel fr binres Serialisieren
 public void bin_Serialisieren_Test()
 {
  // --- Objekt erzeugen und fllen
  Autor a = new Autor();
  a.Name = "Schwichtenberg";
  a.Geb = DateTime.Parse("8/1/1972");
  a.Geschlecht = 'm';

  a.Schwerpunkte = new string[] {"Scripting", "COM", ".NET"};

  // --- Serialisierungsziel
  const string DATEI = "..\\_daten\\Serial\\Autor.xml";

  // --- binre Serialisieren
 Serialisieren_Hilfsroutinen.save(SerialTyp.BINARY, a, DATEI);
 a = (Autor) Serialisieren_Hilfsroutinen.load(SerialTyp.BINARY, DATEI);

  // --- Ausgabe des Objekts zum Test
  Demo.Print(a.Name + " wurde am " + a.Geb + " geboren!");
 }


 // === Beispiel fr XML-Serialisieren
 public void XML_Serialisieren_Test()
 {
  // --- Objekt erzeugen und fllen
  Autor a = new Autor();
  a.Name = "Holger Schwichtenberg";
  a.Geb = DateTime.Parse("8/1/1972");
  a.Geschlecht = 'm';

  a.Schwerpunkte = new string[] {"Scripting", "COM", ".NET"};

  // --- Serialisierungsziel
  const string DATEI = "..\\_daten\\Serial\\Autor.xml";

  // --- binre Serialisieren
  Serialisieren_Hilfsroutinen.save(SerialTyp.XML, a, DATEI);
  a = (Autor) Serialisieren_Hilfsroutinen.load(SerialTyp.XML, DATEI, typeof(Autor));

  // --- Ausgabe des Objekts zum Test
  Demo.Print(a.Name + " wurde am " + a.Geb + " geboren!");
 }





}

public sealed class Samples_SerialisierenFCL
{

 [System.Serializable]
 public class gemischteKlasse
 {
  public System.Xml.XmlNode n;
  public System.Data.DataSet ds = new System.Data.DataSet();

 }


 public static void BCL_serial()
 {

  gemischteKlasse g = new gemischteKlasse();

  const string CONNSTRING = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=..\\_daten\\adonet\\EDVShoa.mdb;";
  const string sql = "SELECT * FROM Produkte WHERE kategorie=23";

  // --- DataSet fllen
  System.Data.OleDb.OleDbDataAdapter DA = null;
  DA = new System.Data.OleDb.OleDbDataAdapter(sql, CONNSTRING);
  DA.Fill(g.ds, "EDV-Antik");

  // XMLDoc fllen
  System.Xml.XmlDocument doc = new System.Xml.XmlDocument();
  doc.Load("..\\_daten\\xml\\hs.xml");
  g.n = doc.SelectSingleNode("*//Buecherliste");

  Serialisieren_Hilfsroutinen.save(SerialTyp.XML, g, "..\\_daten\\xml\\misc.xml");



 }

 // --- Serialisieren in XML (in Speicher)
 public static void xia4()
 {
  const string DATEI = "d:\\test.xml";

  // --- Objekt erzeugen und fllen
  Autor a = new Autor();
  a.Name = "Holger Schwichtenberg";
  a.Geb = DateTime.Parse("8/1/1972");
  a.Geschlecht = 'm';


  Serialisieren_Hilfsroutinen.save(SerialTyp.XML, a, DATEI);

  MemoryStream ms = new MemoryStream();
  // --- Serialisieren in MemoryStream
  XmlSerializer serializer = new XmlSerializer(a.GetType());
  serializer.Serialize(ms, a);
  Demo.Print("Objekt wurde serialisiert!");

  Demo.Print("-- Inhalt des Streams:");
  // --- Stream ausgeben
  StreamReader r = new StreamReader(ms);
  // --- Zeiger auf den Anfang
  r.BaseStream.Seek(0, SeekOrigin.Begin);
  // --- Alle Zeilen lesen und an Console ausgeben
  while (r.Peek() > -1)
  {
   Demo.Print(r.ReadLine());
  }
  //r.Close()

  // --- Datei-Stram
  FileStream fs = new FileStream(DATEI, System.IO.FileMode.Truncate);
  fs.Write(ms.ToArray(), 0, (int) ms.Length);
  fs.Close();
  Demo.Print("Objekt wurde gespeichert in " + DATEI);

  ms.Close();

  Autor p2 = null;
  p2 = (Autor) Serialisieren_Hilfsroutinen.load(SerialTyp.XML, DATEI, typeof(Autor));

  // --- Ausgabe des Objekts zum Test
  Demo.Print(p2.Name + " wurde am " + p2.Geb + " geboren!");

 }


}

 }
